/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.relations.api.Blank;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.exceptions.InvalidPredicateException;
import org.nuxeo.ecm.platform.relations.api.exceptions.InvalidStatementException;
import org.nuxeo.ecm.platform.relations.api.exceptions.InvalidSubjectException;

public class StatementImpl
implements Statement {
    private static final long serialVersionUID = 1L;
    protected Subject subject;
    protected Resource predicate;
    protected Node object;
    protected Map<Resource, Node[]> properties = new HashMap<Resource, Node[]>();

    public StatementImpl() {
    }

    public StatementImpl(Node subject, Node predicate, Node object) {
        boolean validSubject = true;
        try {
            this.setSubject(subject);
        }
        catch (InvalidSubjectException e) {
            validSubject = false;
        }
        boolean validPredicate = true;
        try {
            this.setPredicate(predicate);
        }
        catch (InvalidPredicateException e) {
            validPredicate = false;
        }
        if (!validPredicate && !validSubject) {
            throw new InvalidStatementException();
        }
        if (!validSubject) {
            throw new InvalidSubjectException();
        }
        if (!validPredicate) {
            throw new InvalidPredicateException();
        }
        this.object = object;
    }

    @Override
    public Node getObject() {
        return this.object;
    }

    @Override
    public void setObject(Node object) {
        this.object = object;
    }

    @Override
    public Resource getPredicate() {
        return this.predicate;
    }

    @Override
    public void setPredicate(Node predicate) {
        if (predicate != null && !predicate.isResource()) {
            throw new InvalidPredicateException();
        }
        this.predicate = (Resource)predicate;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(Node subject) {
        if (subject != null) {
            if (subject.isBlank()) {
                this.subject = (Blank)subject;
            } else if (subject.isResource()) {
                this.subject = (Resource)subject;
            } else {
                throw new InvalidSubjectException();
            }
        }
    }

    @Override
    public Map<Resource, Node[]> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, Node[]> getStringProperties() {
        HashMap<String, Node[]> stringProps = new HashMap<String, Node[]>();
        for (Map.Entry<Resource, Node[]> property : this.properties.entrySet()) {
            stringProps.put(property.getKey().getUri(), property.getValue());
        }
        return stringProps;
    }

    @Override
    public Node getProperty(Resource property) {
        Node node = null;
        Node[] values = this.properties.get(property);
        if (values != null && values.length > 0) {
            node = values[0];
        }
        return node;
    }

    @Override
    public Node[] getProperties(Resource property) {
        Node[] values = this.properties.get(property);
        return values;
    }

    @Override
    public void setProperties(Map<Resource, Node[]> properties) {
        if (properties != null) {
            for (Map.Entry<Resource, Node[]> property : properties.entrySet()) {
                this.setProperties(property.getKey(), property.getValue());
            }
        } else {
            this.properties.clear();
        }
    }

    @Override
    public void setProperty(Resource property, Node value) {
        if (property != null && value != null) {
            Node[] values = new Node[]{value};
            this.properties.put(property, values);
        }
    }

    @Override
    public void setProperties(Resource property, Node[] values) {
        if (property != null && values != null && values.length > 0) {
            this.properties.put(property, values);
        }
    }

    @Override
    public void deleteProperties() {
        this.properties.clear();
    }

    @Override
    public void deleteProperty(Resource property) {
        this.properties.remove(property);
    }

    @Override
    public void deleteProperty(Resource property, Node value) {
        if (this.properties.containsKey(property)) {
            ArrayList<Object> valuesList = new ArrayList<Object>();
            valuesList.addAll(Arrays.asList((Object[])this.properties.get(property)));
            valuesList.remove(value);
            if (valuesList.isEmpty()) {
                this.properties.remove(property);
            } else {
                this.properties.put(property, valuesList.toArray(new Node[0]));
            }
        }
    }

    @Override
    public void deleteProperties(Resource property, Node[] values) {
        if (this.properties.containsKey(property) && values != null && values.length > 0) {
            ArrayList<Object> valuesList = new ArrayList<Object>();
            valuesList.addAll(Arrays.asList((Object[])this.properties.get(property)));
            valuesList.removeAll(Arrays.asList(values));
            if (valuesList.isEmpty()) {
                this.properties.remove(property);
            } else {
                this.properties.put(property, valuesList.toArray(new Node[0]));
            }
        }
    }

    @Override
    public void addProperties(Map<Resource, Node[]> properties) {
        if (properties != null) {
            for (Map.Entry<Resource, Node[]> property : properties.entrySet()) {
                this.addProperties(property.getKey(), property.getValue());
            }
        }
    }

    @Override
    public void addProperty(Resource property, Node value) {
        if (property != null && value != null) {
            if (this.properties.containsKey(property)) {
                ArrayList<Object> valuesList = new ArrayList<Object>();
                valuesList.addAll(Arrays.asList((Object[])this.properties.get(property)));
                if (!valuesList.contains(value)) {
                    valuesList.add(value);
                    this.properties.put(property, valuesList.toArray(new Node[0]));
                }
            } else {
                Node[] values = new Node[]{value};
                this.properties.put(property, values);
            }
        }
    }

    @Override
    public void addProperties(Resource property, Node[] values) {
        if (property != null && values != null && values.length > 0) {
            if (this.properties.containsKey(property)) {
                ArrayList<Object> valuesList = new ArrayList<Object>();
                valuesList.addAll(Arrays.asList((Object[])this.properties.get(property)));
                boolean changed = false;
                for (Node value : values) {
                    if (valuesList.contains(value)) continue;
                    valuesList.add(value);
                    changed = true;
                }
                if (changed) {
                    this.properties.put(property, valuesList.toArray(new Node[0]));
                }
            } else {
                this.properties.put(property, values);
            }
        }
    }

    public String toString() {
        return String.format("%s(%s, %s, %s)", this.getClass().getSimpleName(), this.subject, this.predicate, this.object);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StatementImpl)) {
            return false;
        }
        StatementImpl otherStatement = (StatementImpl)other;
        return this.subject.equals(otherStatement.subject) && this.predicate.equals(otherStatement.predicate) && this.object.equals(otherStatement.object);
    }

    public int hashCode() {
        int result = 17;
        result = 17 * result + this.subject.hashCode();
        result = 17 * result + this.predicate.hashCode();
        result = 17 * result + this.object.hashCode();
        return result;
    }

    @Override
    public int compareTo(Statement o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StatementImpl clone = (StatementImpl)super.clone();
        HashMap<Resource, Node[]> clonedProperties = new HashMap<Resource, Node[]>();
        for (Map.Entry<Resource, Node[]> property : this.properties.entrySet()) {
            clonedProperties.put(property.getKey(), (Node[])property.getValue().clone());
        }
        clone.properties = clonedProperties;
        return clone;
    }
}

