/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.ecm.core.cache.CacheRegistry;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class CacheServiceImpl
extends DefaultComponent
implements CacheService {
    public static final String DEFAULT_CACHE_ID = "default-cache";
    public static final ComponentName NAME = new ComponentName(CacheServiceImpl.class.getName());
    private static final Log log = LogFactory.getLog(CacheServiceImpl.class);
    protected final CacheRegistry cacheRegistry = new CacheRegistry();
    protected final List<String> autoregisteredCacheNames = new ArrayList<String>();

    @Override
    public CacheAttributesChecker getCache(String name) {
        return this.cacheRegistry.getCache(name);
    }

    public CacheAttributesChecker getDefaultCache() {
        if (this.getCache(DEFAULT_CACHE_ID) == null) {
            CacheDescriptor desc = new CacheDescriptor();
            desc.name = DEFAULT_CACHE_ID;
            desc.start();
            this.autoregisteredCacheNames.add(DEFAULT_CACHE_ID);
            this.cacheRegistry.caches.put(DEFAULT_CACHE_ID, desc);
        }
        return this.getCache(DEFAULT_CACHE_ID);
    }

    public void deactivate(ComponentContext context) {
        if (this.cacheRegistry.caches.size() > 0) {
            HashMap<String, CacheDescriptor> descriptors = new HashMap<String, CacheDescriptor>(this.cacheRegistry.caches);
            for (CacheDescriptor desc : descriptors.values()) {
                this.cacheRegistry.contributionRemoved(desc.name, desc);
                if (this.autoregisteredCacheNames.remove(desc.name)) continue;
                log.warn((Object)("Unregistery leaked contribution " + desc.name));
            }
        }
    }

    public int getApplicationStartedOrder() {
        ComponentInstance repositoryComponent = Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.core.repository.RepositoryServiceComponent");
        if (repositoryComponent == null) {
            return super.getApplicationStartedOrder();
        }
        return ((DefaultComponent)repositoryComponent.getInstance()).getApplicationStartedOrder() - 5;
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (0 != event.id) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                CacheServiceImpl.this.cacheRegistry.stop();
            }
        });
        this.cacheRegistry.start();
    }

    public void registerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            CacheDescriptor descriptor = (CacheDescriptor)contrib;
            this.cacheRegistry.addContribution(descriptor);
        }
    }

    @Override
    public void registerCache(String name, int maxSize, int timeout) {
        CacheDescriptor desc = this.cacheRegistry.caches.get(DEFAULT_CACHE_ID) != null ? new CacheDescriptor(this.cacheRegistry.caches.get(DEFAULT_CACHE_ID)) : new CacheDescriptor();
        desc.name = name;
        desc.ttl = timeout;
        desc.options.put("maxSize", String.valueOf(maxSize));
        if (this.cacheRegistry.caches.get(name) == null) {
            this.cacheRegistry.addContribution(desc);
            this.autoregisteredCacheNames.add(name);
        } else {
            CacheDescriptor oldDesc = this.cacheRegistry.caches.get(name);
            this.cacheRegistry.merge(oldDesc, desc);
        }
    }

    public void unregisterExtension(Extension extension) throws RuntimeException {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            CacheDescriptor descriptor = (CacheDescriptor)contrib;
            this.cacheRegistry.removeContribution(descriptor);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(CacheRegistry.class)) {
            return adapter.cast((Object)this.cacheRegistry);
        }
        return (T)super.getAdapter(adapter);
    }
}

