/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import java.util.Arrays;
import java.util.List;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.OperationInfo;
import org.nuxeo.ecm.automation.OperationDocumentation;

public class OperationInfoImpl
extends BaseNuxeoArtifact
implements OperationInfo {
    public final OperationDocumentation op;
    public final String version;
    protected final String operationClass;
    protected final String contributingComponent;

    public OperationInfoImpl(OperationDocumentation op, String version, String operationClass, String contributingComponent) {
        String[] parts;
        this.op = op;
        this.version = version;
        this.operationClass = operationClass;
        this.contributingComponent = contributingComponent == null || contributingComponent.isEmpty() ? "BuiltIn" : ((parts = contributingComponent.split(":")).length > 1 ? parts[1] : contributingComponent);
    }

    @Override
    public String getName() {
        return this.op.getId();
    }

    @Override
    public String getId() {
        return "op:" + this.op.getId();
    }

    @Override
    public String getDescription() {
        return this.op.getDescription();
    }

    @Override
    public String[] getSignature() {
        return this.op.getSignature();
    }

    @Override
    public String getCategory() {
        return this.op.getCategory();
    }

    @Override
    public String getUrl() {
        return this.op.getUrl();
    }

    @Override
    public String getLabel() {
        return this.op.getLabel();
    }

    @Override
    public String getRequires() {
        return this.op.getRequires();
    }

    @Override
    public String getSince() {
        return this.op.since;
    }

    @Override
    public List<OperationDocumentation.Param> getParams() {
        return Arrays.asList(this.op.getParams());
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getArtifactType() {
        return "NXOperation";
    }

    @Override
    public String getHierarchyPath() {
        return "/";
    }

    @Override
    public int compareTo(OperationInfo o) {
        String s1 = this.getLabel() == null ? this.getId() : this.getLabel();
        String s2 = o.getLabel() == null ? o.getId() : o.getLabel();
        return s1.compareTo(s2);
    }

    @Override
    public String getOperationClass() {
        return this.operationClass;
    }

    @Override
    public String getContributingComponent() {
        return this.contributingComponent;
    }
}

