/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.platform.portal.notifications.bean;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;

@Name(value="routingNotifications")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=32)
public class RoutingNotificationsSwitch
implements Serializable {
    @In(create=true)
    protected transient CoreSession documentManager;
    @In
    protected transient EventService eventService;
    private static final long serialVersionUID = -5223906396024845056L;
    private boolean isFirstNode;
    private List<String> actors = new ArrayList<String>();

    @Observer(value={"workflowProcessCanceled"})
    public void redirectToWfCanceledEvent() {
        if (!this.isFirstNode) {
            Principal principal = this.documentManager.getPrincipal();
            NavigationContext navCtx = (NavigationContext)SeamComponentCallHelper.getSeamComponentByName((String)"navigationContext");
            DocumentModel currentDocument = navCtx.getCurrentDocument();
            HashMap<String, String[]> properties = new HashMap<String, String[]>();
            properties.put("recipients", this.actors.toArray(new String[0]));
            DocumentEventContext docCtx = new DocumentEventContext(this.documentManager, principal, currentDocument);
            this.eventService.fireEvent("workflowProcessCanceled", (EventContext)docCtx);
        }
    }

    protected DocumentModel getStartNode(CoreSession documentManager, DocumentModel documentModelRoute) {
        DocumentModel startNode = null;
        Filter startNodeFilter = new Filter(){
            private static final long serialVersionUID = -1362865077000277152L;

            public boolean accept(DocumentModel docModel) {
                return (Boolean)docModel.getPropertyValue("rnode:start");
            }
        };
        DocumentModelList children = documentManager.getChildren(documentModelRoute.getRef(), "RouteNode", startNodeFilter, null);
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            startNode = (DocumentModel)children.get(0);
        }
        return startNode;
    }

    protected String getFirstNodeName(CoreSession documentManager, DocumentModel documentModelRoute) {
        String name = null;
        DocumentModel startNode = this.getStartNode(documentManager, documentModelRoute);
        if (startNode != null) {
            name = (String)((Object)startNode.getPropertyValue("rnode:transitions/0/targetId"));
        }
        return name;
    }
}

