/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import org.codehaus.jackson.node.ObjectNode;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

public class JSONStringBlobDecoder
implements JSONBlobDecoder {
    @Override
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        StringBlob blob = null;
        String filename = null;
        if (jsonObject.has("filename")) {
            filename = jsonObject.get("filename").getTextValue();
        }
        if (filename == null && jsonObject.has("name")) {
            filename = jsonObject.get("name").getTextValue();
        }
        String encoding = "UTF-8";
        if (jsonObject.has("encoding")) {
            encoding = jsonObject.get("encoding").getTextValue();
        }
        String mimetype = "text/plain";
        if (jsonObject.has("mime-type")) {
            mimetype = jsonObject.get("mime-type").getTextValue();
        }
        String data = null;
        if (jsonObject.has("data")) {
            data = jsonObject.get("data").getTextValue();
            if (data.startsWith("http")) {
                data = null;
            }
        } else if (jsonObject.has("content")) {
            data = jsonObject.get("content").getTextValue();
        }
        if (data == null) {
            return null;
        }
        blob = new StringBlob(data, mimetype, encoding);
        return blob;
    }
}

