/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.attached.images.bean;

import fr.toutatice.ecm.platform.core.helper.ToutaticeFileHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeImageCollectionHelper;
import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActionsBean;
import fr.toutatice.ecm.platform.web.webeditor.ToutaticeEditorImageActionsBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Part;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;

@Name(value="editorImageActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=131)
public class OttcEditorImageActionsBean
extends ToutaticeEditorImageActionsBean {
    private static final long serialVersionUID = -5167514978372946152L;
    private static final Log log = LogFactory.getLog(OttcEditorImageActionsBean.class);
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    private boolean isImage = true;

    public String uploadImage() throws ClientException {
        Part uploadedImg = this.getUploadedImage();
        if (uploadedImg == null) {
            return null;
        }
        String uploadedImgName = FileUtils.retrieveFilename((Part)uploadedImg);
        if (null == uploadedImg || StringUtils.isBlank((String)uploadedImgName)) {
            return null;
        }
        try {
            ToutaticeDocumentActionsBean actionsbean = (ToutaticeDocumentActionsBean)SeamComponentCallHelper.getSeamComponentByName((String)"documentActions");
            DocumentModel doc = actionsbean.getCurrentDocument();
            Blob uploadedImageBlob = FileUtils.createSerializableBlob((InputStream)uploadedImg.getInputStream(), (String)uploadedImgName, (String)uploadedImg.getContentType());
            boolean isImage = ToutaticeFileHelper.instance().isImageTypeFile(uploadedImgName, uploadedImageBlob);
            if (isImage) {
                List files = (List)((Object)doc.getPropertyValue("ttc:images"));
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("filename", uploadedImgName);
                item.put("file", (String)uploadedImageBlob);
                ToutaticeImageCollectionHelper.instance().add(files, item);
                doc.setPropertyValue("ttc:images", (Serializable)((Object)files));
                if (StringUtils.isNotBlank((String)doc.getId())) {
                    this.documentManager.saveDocument(doc);
                }
            } else {
                this.isImage = false;
                log.debug((Object)"The binary file to upload hasn't the correct mimetype.");
            }
            return "editor_image_upload";
        }
        catch (IOException e) {
            log.error((Object)("Failed to upload the image, error: " + e.getMessage()));
            throw new ClientException((Throwable)e);
        }
    }
}

