/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.navigation;

import org.jboss.seam.bpm.BusinessProcess;
import org.jboss.seam.core.Expressions;

public class TaskControl {
    private boolean isBeginTask;
    private boolean isStartTask;
    private boolean isEndTask;
    private Expressions.ValueExpression<Long> taskId;
    private Expressions.ValueExpression<String> transition;

    public void beginOrEndTask() {
        if (this.endTask()) {
            BusinessProcess.instance().validateTask();
            BusinessProcess.instance().endTask(this.transition == null ? null : this.transition.getValue());
        }
        if (this.beginTask() || this.startTask()) {
            if (this.taskId == null || this.taskId.getValue() == null) {
                throw new NullPointerException("task id may not be null");
            }
            BusinessProcess.instance().resumeTask(this.taskId.getValue());
        }
        if (this.startTask()) {
            BusinessProcess.instance().startTask();
        }
    }

    private boolean beginTask() {
        return this.isBeginTask && this.taskId.getValue() != null;
    }

    private boolean startTask() {
        return this.isStartTask && this.taskId.getValue() != null;
    }

    private boolean endTask() {
        return this.isEndTask;
    }

    public boolean isBeginTask() {
        return this.isBeginTask;
    }

    public void setBeginTask(boolean isBeginTask) {
        this.isBeginTask = isBeginTask;
    }

    public boolean isEndTask() {
        return this.isEndTask;
    }

    public void setEndTask(boolean isEndTask) {
        this.isEndTask = isEndTask;
    }

    public boolean isStartTask() {
        return this.isStartTask;
    }

    public void setStartTask(boolean isStartTask) {
        this.isStartTask = isStartTask;
    }

    public void setTaskId(Expressions.ValueExpression<Long> taskId) {
        this.taskId = taskId;
    }

    public Expressions.ValueExpression<Long> getTaskId() {
        return this.taskId;
    }

    public Expressions.ValueExpression<String> getTransition() {
        return this.transition;
    }

    public void setTransition(Expressions.ValueExpression<String> transition) {
        this.transition = transition;
    }
}

