/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf.operations;

import java.io.IOException;
import java.util.UUID;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Operation(id="Seam.DownloadFile", category="User Interface", requires="Seam", label="Download file", description="Download a file")
public class DownloadFile {
    protected static Log log = LogFactory.getLog(DownloadFile.class);
    public static final String ID = "Seam.DownloadFile";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public void run(Blob blob) throws Exception {
        if (blob == null) {
            throw new OperationException("there is no file content available");
        }
        FacesContext faces = FacesContext.getCurrentInstance();
        String filename = blob.getFilename();
        if (blob.getLength() > Functions.getBigFileSizeLimit()) {
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            if (!blob.isPersistent()) {
                blob.persist();
            }
            String sid = UUID.randomUUID().toString();
            request.getSession(true).setAttribute(sid, (Object)blob);
            String bigDownloadURL = BaseURL.getBaseURL((ServletRequest)request);
            bigDownloadURL = bigDownloadURL + "nxbigblob/" + sid;
            try {
                request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)new Boolean(true));
                response.sendRedirect(bigDownloadURL);
                response.flushBuffer();
                FacesContext.getCurrentInstance().responseComplete();
                this.ctx.getVars().put("Outcome", null);
            }
            catch (IOException e) {
                log.error((Object)"Error while redirecting for big blob downloader", (Throwable)e);
            }
        } else {
            ComponentUtils.download((FacesContext)faces, (Blob)blob, (String)filename);
        }
    }
}

