/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.op;

import it.tidalwave.image.Quality;
import it.tidalwave.image.op.Operation;
import it.tidalwave.image.render.PreviewSettings;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.ImageObserver;

public class PaintOp
extends Operation {
    private final int x;
    private final int y;
    private final int w;
    private final int h;
    private final Graphics2D g2;
    private final Quality quality;
    private final PreviewSettings previewSettings;
    private final ImageObserver imageObserver;

    public PaintOp(Graphics2D g2, int x, int y, int w, int h, Quality quality, PreviewSettings previewSettings, ImageObserver imageObserver) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.g2 = g2;
        this.quality = quality;
        this.previewSettings = previewSettings;
        this.imageObserver = imageObserver;
    }

    public PaintOp(Graphics2D g2, int x, int y, int w, int h, PreviewSettings previewSettings, ImageObserver imageObserver) {
        this(g2, x, y, w, h, Quality.FASTEST, previewSettings, imageObserver);
    }

    public PaintOp(Graphics2D g2, int x, int y, PreviewSettings previewSettings, ImageObserver imageObserver) {
        this(g2, x, y, 0, 0, previewSettings, imageObserver);
    }

    public PaintOp(Graphics2D g2, int x, int y, PreviewSettings previewSettings) {
        this(g2, x, y, 0, 0, previewSettings, null);
    }

    public PaintOp(Graphics2D g2, Point position, PreviewSettings previewSettings) {
        this(g2, position.x, position.y, previewSettings);
    }

    public PaintOp(Graphics2D g2, int x, int y) {
        this(g2, x, y, 0, 0, null, null);
    }

    public PaintOp(Graphics2D g2, Point position) {
        this(g2, position.x, position.y);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public Graphics2D getGraphics2D() {
        return this.g2;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public PreviewSettings getPreviewSettings() {
        return this.previewSettings;
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    public String toString() {
        return "PaintOp(x:" + this.x + ", y:" + this.y + ", w:" + this.w + ", h:" + this.h + ", " + (Object)((Object)this.quality) + ")";
    }
}

