/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.AlgebraGenerator;
import com.hp.hpl.jena.sparql.algebra.AlgebraQuad;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformUnionQuery;
import com.hp.hpl.jena.sparql.algebra.optimize.Optimize;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineRef;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderOp;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.Iterator;

public class Algebra {
    public static Op optimize(Op op) {
        return Algebra.optimize(op, null);
    }

    public static Op optimize(Op op, Context context) {
        if (context == null) {
            context = ARQ.getContext();
        }
        if (op == null) {
            return null;
        }
        return Optimize.optimize(op, context);
    }

    public static Op compile(Query query2) {
        if (query2 == null) {
            return null;
        }
        return new AlgebraGenerator().compile(query2);
    }

    public static Op compile(Element elt) {
        if (elt == null) {
            return null;
        }
        return new AlgebraGenerator().compile(elt);
    }

    public static Op toQuadForm(Op op) {
        return AlgebraQuad.quadize(op);
    }

    public static Op unionDefaultGraph(Op op) {
        return TransformUnionQuery.transform(op);
    }

    public static Op read(String filename) {
        Item item = SSE.readFile(filename);
        return Algebra.parse(item);
    }

    public static Op parse(String string) {
        Item item = SSE.parse(string);
        return Algebra.parse(item);
    }

    public static Op parse(String string, PrefixMapping pmap) {
        Item item = SSE.parse(string, pmap);
        return Algebra.parse(item);
    }

    public static Op parse(Item item) {
        Op op = BuilderOp.build(item);
        return op;
    }

    public static QueryIterator exec(Op op, Dataset ds) {
        return Algebra.exec(op, ds.asDatasetGraph());
    }

    public static QueryIterator exec(Op op, Model model) {
        return Algebra.exec(op, model.getGraph());
    }

    public static QueryIterator exec(Op op, Graph graph) {
        return Algebra.exec(op, DatasetGraphFactory.createOneGraph(graph));
    }

    public static QueryIterator exec(Op op, DatasetGraph ds) {
        QueryEngineFactory f = QueryEngineRegistry.findFactory(op, ds, null);
        Plan plan = f.create(op, ds, BindingRoot.create(), null);
        return plan.iterator();
    }

    public static QueryIterator execRef(Op op, Dataset ds) {
        return Algebra.execRef(op, ds.asDatasetGraph());
    }

    public static QueryIterator execRef(Op op, Model model) {
        return Algebra.execRef(op, model.getGraph());
    }

    public static QueryIterator execRef(Op op, Graph graph) {
        return Algebra.execRef(op, DatasetGraphFactory.createOneGraph(graph));
    }

    public static QueryIterator execRef(Op op, DatasetGraph ds) {
        QueryEngineRef qe = new QueryEngineRef(op, ds, null);
        return qe.getPlan().iterator();
    }

    public static Binding merge(Binding bindingLeft, Binding bindingRight) {
        boolean matches = Algebra.compatible(bindingLeft, bindingRight);
        if (!matches) {
            return null;
        }
        BindingMap b = new BindingMap(bindingLeft);
        Iterator<Var> vIter = bindingRight.vars();
        while (vIter.hasNext()) {
            Var v = vIter.next();
            Node n = bindingRight.get(v);
            if (bindingLeft.contains(v)) continue;
            b.add(v, n);
        }
        return b;
    }

    public static boolean compatible(Binding bindingLeft, Binding bindingRight) {
        Iterator<Var> vIter = bindingLeft.vars();
        while (vIter.hasNext()) {
            Var v = vIter.next();
            Node nLeft = bindingLeft.get(v);
            Node nRight = bindingRight.get(v);
            if (nRight == null || nRight.equals((Object)nLeft)) continue;
            return false;
        }
        return true;
    }

    public static boolean disjoint(Binding binding1, Binding binding2) {
        Iterator<Var> iterVar1 = binding1.vars();
        while (iterVar1.hasNext()) {
            Var v = iterVar1.next();
            if (!binding2.contains(v)) continue;
            return false;
        }
        return true;
    }
}

