/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddressType;

public class HostAddress {
    private HostAddressType addressType;
    private byte[] address;

    public HostAddress(HostAddressType addressType, byte[] address) {
        this.addressType = addressType;
        this.address = address;
    }

    public HostAddress(InetAddress internetAddress) {
        this.addressType = HostAddressType.ADDRTYPE_IPV4;
        byte[] newAddress = internetAddress.getAddress();
        this.address = new byte[newAddress.length];
        System.arraycopy(newAddress, 0, this.address, 0, newAddress.length);
    }

    public boolean equals(HostAddress that) {
        if (this.addressType != that.addressType || this.address != null && that.address == null || this.address == null && that.address != null) {
            return false;
        }
        if (this.address != null && that.address != null) {
            if (this.address.length != that.address.length) {
                return false;
            }
            for (int ii = 0; ii < this.address.length; ++ii) {
                if (this.address[ii] == that.address[ii]) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public HostAddressType getAddressType() {
        return this.addressType;
    }

    public String toString() {
        String result = "";
        try {
            result = InetAddress.getByAddress(this.address).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }
}

