/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.file;

import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class FileInfosProvider
implements DocumentInformationsProvider {
    public static final String IS_PDF_CONVERTIBLE = "isPdfConvertible";
    public static final String ERROR_ON_PDF_CONVERSION = "errorOnPdfConversion";
    public static final String TTC_ANY_2_PDF_CONVERTER = "toutaticeAny2pdf";
    private static MimetypeRegistry mimetypeRegistry;
    private static ConversionService conversionService;

    public static ConversionService getConversionService() {
        if (conversionService == null) {
            conversionService = (ConversionService)Framework.getService(ConversionService.class);
        }
        return conversionService;
    }

    @Override
    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        BlobHolder bh;
        Blob blob;
        HashMap<String, Object> infos = new HashMap<String, Object>(1);
        boolean convertible = false;
        if (currentDocument != null && currentDocument.hasSchema("file") && (blob = (bh = (BlobHolder)currentDocument.getAdapter(BlobHolder.class)).getBlob()) != null) {
            String mimeType = blob.getMimeType();
            if ("application/pdf".equals(mimeType)) {
                convertible = true;
            } else {
                convertible = FileInfosProvider.getConversionService().isSourceMimeTypeSupported(TTC_ANY_2_PDF_CONVERTER, mimeType);
                if (!convertible && StringUtils.startsWith((String)mimeType, (String)"text/")) {
                    convertible = true;
                }
            }
        }
        infos.put(IS_PDF_CONVERTIBLE, convertible);
        return infos;
    }
}

