/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.util.FacesUrlTransformer;

public class SeamViewHandler
extends ViewHandlerWrapper {
    private ViewHandler viewHandler;
    private static final ThreadLocal<Source> source = new ThreadLocal();

    public SeamViewHandler(ViewHandler viewHandler) {
        this.viewHandler = viewHandler;
    }

    public String calculateCharacterEncoding(FacesContext context) {
        return this.viewHandler.calculateCharacterEncoding(context);
    }

    public void initView(FacesContext context) throws FacesException {
        this.viewHandler.initView(context);
    }

    public Locale calculateLocale(FacesContext facesContext) {
        Locale jsfLocale = this.viewHandler.calculateLocale(facesContext);
        if (!Contexts.isSessionContextActive()) {
            return jsfLocale;
        }
        return LocaleSelector.instance().calculateLocale(jsfLocale);
    }

    public String calculateRenderKitId(FacesContext ctx) {
        return this.viewHandler.calculateRenderKitId(ctx);
    }

    public UIViewRoot createView(FacesContext ctx, String viewId) {
        return this.viewHandler.createView(ctx, viewId);
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        String actionUrl = super.getActionURL(facesContext, viewId);
        Conversation conversation = Conversation.instance();
        Manager manager = Manager.instance();
        String conversationIdParameter = manager.getConversationIdParameter();
        if (!this.getSource().equals((Object)Source.BOOKMARKABLE) && !this.getSource().equals((Object)Source.REDIRECT)) {
            if (conversation.isLongRunning()) {
                return new FacesUrlTransformer(actionUrl, facesContext).appendConversationIdIfNecessary(conversationIdParameter, conversation.getId()).getUrl();
            }
            if (conversation.isNested()) {
                return new FacesUrlTransformer(actionUrl, facesContext).appendConversationIdIfNecessary(conversationIdParameter, conversation.getParentId()).getUrl();
            }
            return actionUrl;
        }
        return actionUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        try {
            source.set(Source.REDIRECT);
            String string = super.getRedirectURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        try {
            source.set(Source.BOOKMARKABLE);
            String string = this.viewHandler.getBookmarkableURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            source.remove();
        }
    }

    private Source getSource() {
        if (source.get() == null) {
            return Source.ACTION;
        }
        return source.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceURL(FacesContext ctx, String path) {
        try {
            source.set(Source.RESOURCE);
            String string = super.getResourceURL(ctx, path);
            return string;
        }
        finally {
            source.remove();
        }
    }

    public void renderView(FacesContext ctx, UIViewRoot viewRoot) throws IOException, FacesException {
        this.viewHandler.renderView(ctx, viewRoot);
    }

    public UIViewRoot restoreView(FacesContext ctx, String viewId) {
        UIViewRoot viewRoot = this.viewHandler.restoreView(ctx, viewId);
        if (viewRoot != null) {
            viewRoot.setViewId(this.viewHandler.deriveViewId(ctx, viewId));
        }
        return viewRoot;
    }

    public void writeState(FacesContext ctx) throws IOException {
        this.viewHandler.writeState(ctx);
    }

    public ViewHandler getWrapped() {
        return this.viewHandler;
    }

    private static enum Source {
        ACTION,
        BOOKMARKABLE,
        REDIRECT,
        RESOURCE;

    }
}

