/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryMethodSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.14";
    private static final String[] PDMS = new String[]{"any", "mhs", "physical", "telex", "teletex", "g3fax", "g4fax", "ia5", "videotex", "telephone"};
    private static final Set<String> DELIVERY_METHODS = new HashSet<String>();

    public DeliveryMethodSyntaxChecker() {
        super(SC_OID);
    }

    protected DeliveryMethodSyntaxChecker(String oid) {
        super(oid);
    }

    private int isPdm(String strValue, int pos, Set<String> pmds) {
        int start = pos;
        while (StringTools.isAlphaDigit(strValue, pos)) {
            ++pos;
        }
        if (pos == start) {
            return -1;
        }
        String pmd = strValue.substring(start, pos);
        if (!DELIVERY_METHODS.contains(pmd)) {
            return -1;
        }
        if (pmds.contains(pmd)) {
            return -1;
        }
        pmds.add(pmd);
        return pos;
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        int length = strValue.length();
        int pos = 0;
        HashSet<String> pmds = new HashSet<String>();
        if ((pos = this.isPdm(strValue, pos, pmds)) == -1) {
            return false;
        }
        while (pos < length) {
            while (StringTools.isCharASCII(strValue, pos, ' ')) {
                ++pos;
            }
            if (!StringTools.isCharASCII(strValue, pos, '$')) {
                return false;
            }
            ++pos;
            while (StringTools.isCharASCII(strValue, pos, ' ')) {
                ++pos;
            }
            if ((pos = this.isPdm(strValue, pos, pmds)) != -1) continue;
            return false;
        }
        return true;
    }

    static {
        for (String country : PDMS) {
            DELIVERY_METHODS.add(country);
        }
    }
}

