/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.instances.operations;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;

@Operation(id="Services.CreateDocumentFromAttachment", category="Services", label="CreateDocumentFromAttachment", description="Creates a document file in the current user workspace from a blob in another document.")
public class CreateDocumentFromAttachment {
    public static final String ID = "Services.CreateDocumentFromAttachment";
    @Param(name="variableName", required=true)
    private String variableName;
    @Param(name="overwite", required=false)
    protected Boolean overwite = false;
    @Context
    CoreSession session;
    @Context
    UserWorkspaceService userWorkspaceService;
    @Context
    FileManager fileManager;

    @OperationMethod
    public DocumentModel run(DocumentModel documentModel) throws Exception {
        DocumentModel currentUserPersonalWorkspace = this.userWorkspaceService.getCurrentUserPersonalWorkspace(this.session, documentModel);
        return this.fileManager.createDocumentFromBlob(this.session, this.getBlobFromDocument(documentModel), currentUserPersonalWorkspace.getPathAsString(), this.overwite.booleanValue(), this.getBlobFromDocument(documentModel).getFilename());
    }

    private Blob getBlobFromDocument(DocumentModel documentModel) {
        List attachmentsTypeList = (List)((Object)documentModel.getPropertyValue("attachments"));
        for (Map attachmentsmap : attachmentsTypeList) {
            if (!StringUtils.equals((String)((String)attachmentsmap.get("variableName")), (String)this.variableName)) continue;
            return (Blob)attachmentsmap.get("blob");
        }
        return null;
    }
}

