/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.ConnectionPropertiesImpl;
import com.mysql.jdbc.LoadBalancingConnectionProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverConnectionProxy
extends LoadBalancingConnectionProxy {
    boolean failedOver;
    boolean hasTriedMaster;
    private long masterFailTimeMillis;
    boolean preferSlaveDuringFailover;
    private String primaryHostPortSpec;
    private long queriesBeforeRetryMaster;
    long queriesIssuedFailedOver;
    private int secondsBeforeRetryMaster;

    FailoverConnectionProxy(List<String> hosts, Properties props) throws SQLException {
        super(hosts, props);
        ConnectionPropertiesImpl connectionProps = new ConnectionPropertiesImpl();
        connectionProps.initializeProperties(props);
        this.queriesBeforeRetryMaster = connectionProps.getQueriesBeforeRetryMaster();
        this.secondsBeforeRetryMaster = connectionProps.getSecondsBeforeRetryMaster();
        this.preferSlaveDuringFailover = false;
    }

    @Override
    protected LoadBalancingConnectionProxy.ConnectionErrorFiringInvocationHandler createConnectionProxy(Object toProxy) {
        return new FailoverInvocationHandler(toProxy);
    }

    @Override
    synchronized void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        Throwable t = e.getTargetException();
        if (t != null) {
            if (this.failedOver) {
                this.createPrimaryConnection();
                if (this.currentConn != null) {
                    throw t;
                }
            }
            this.failOver();
            throw t;
        }
        throw e;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("setPreferSlaveDuringFailover".equals(methodName)) {
            this.preferSlaveDuringFailover = (Boolean)args[0];
        } else if ("clearHasTriedMaster".equals(methodName)) {
            this.hasTriedMaster = false;
        } else {
            if ("hasTriedMaster".equals(methodName)) {
                return this.hasTriedMaster;
            }
            if ("isMasterConnection".equals(methodName)) {
                return !this.failedOver;
            }
            if ("isSlaveConnection".equals(methodName)) {
                return this.failedOver;
            }
            if ("setReadOnly".equals(methodName)) {
                if (this.failedOver) {
                    return null;
                }
            } else if ("setAutoCommit".equals(methodName) && this.failedOver && this.shouldFallBack() && Boolean.TRUE.equals(args[0]) && this.failedOver) {
                this.createPrimaryConnection();
                return super.invoke(proxy, method, args, this.failedOver);
            }
        }
        return super.invoke(proxy, method, args, this.failedOver);
    }

    private synchronized void createPrimaryConnection() throws SQLException {
        block2: {
            try {
                this.currentConn = this.createConnectionForHost(this.primaryHostPortSpec);
                this.failedOver = false;
                this.hasTriedMaster = true;
                this.queriesIssuedFailedOver = 0L;
            }
            catch (SQLException sqlEx) {
                this.failedOver = true;
                if (this.currentConn == null) break block2;
                this.currentConn.getLog().logWarn("Connection to primary host failed", sqlEx);
            }
        }
    }

    @Override
    synchronized void invalidateCurrentConnection() throws SQLException {
        if (!this.failedOver) {
            this.failedOver = true;
            this.queriesIssuedFailedOver = 0L;
            this.masterFailTimeMillis = System.currentTimeMillis();
        }
        super.invalidateCurrentConnection();
    }

    @Override
    protected synchronized void pickNewConnection() throws SQLException {
        if (this.primaryHostPortSpec == null) {
            this.primaryHostPortSpec = (String)this.hostList.remove(0);
        }
        if (this.currentConn == null || this.failedOver && this.shouldFallBack()) {
            this.createPrimaryConnection();
            if (this.currentConn != null) {
                return;
            }
        }
        this.failOver();
    }

    private synchronized void failOver() throws SQLException {
        if (this.failedOver) {
            for (Map.Entry entry : this.liveConnections.entrySet()) {
                ((ConnectionImpl)entry.getValue()).close();
            }
            this.liveConnections.clear();
        }
        super.pickNewConnection();
        if (this.currentConn.getFailOverReadOnly()) {
            this.currentConn.setReadOnly(true);
        } else {
            this.currentConn.setReadOnly(false);
        }
        this.failedOver = true;
    }

    private boolean shouldFallBack() {
        long secondsSinceFailedOver = (System.currentTimeMillis() - this.masterFailTimeMillis) / 1000L;
        if (secondsSinceFailedOver >= (long)this.secondsBeforeRetryMaster) {
            this.masterFailTimeMillis = System.currentTimeMillis();
            return true;
        }
        return this.queriesBeforeRetryMaster != 0L && this.queriesIssuedFailedOver >= this.queriesBeforeRetryMaster;
    }

    class FailoverInvocationHandler
    extends LoadBalancingConnectionProxy.ConnectionErrorFiringInvocationHandler {
        public FailoverInvocationHandler(Object toInvokeOn) {
            super(FailoverConnectionProxy.this, toInvokeOn);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (FailoverConnectionProxy.this.failedOver && methodName.indexOf("execute") != -1) {
                ++FailoverConnectionProxy.this.queriesIssuedFailedOver;
            }
            return super.invoke(proxy, method, args);
        }
    }
}

