/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.io.IOException;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;

public class PendingClusterTask
implements Streamable {
    private long insertOrder;
    private Priority priority;
    private Text source;
    private long timeInQueue;

    public PendingClusterTask() {
    }

    public PendingClusterTask(long insertOrder, Priority priority, Text source, long timeInQueue) {
        this.insertOrder = insertOrder;
        this.priority = priority;
        this.source = source;
        this.timeInQueue = timeInQueue;
    }

    public long insertOrder() {
        return this.insertOrder;
    }

    public long getInsertOrder() {
        return this.insertOrder();
    }

    public Priority priority() {
        return this.priority;
    }

    public Priority getPriority() {
        return this.priority();
    }

    public Text source() {
        return this.source;
    }

    public Text getSource() {
        return this.source();
    }

    public long timeInQueueInMillis() {
        return this.timeInQueue;
    }

    public long getTimeInQueueInMillis() {
        return this.timeInQueueInMillis();
    }

    public TimeValue getTimeInQueue() {
        return new TimeValue(this.getTimeInQueueInMillis());
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.insertOrder = in.readVLong();
        this.priority = Priority.readFrom(in);
        this.source = in.readText();
        this.timeInQueue = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.insertOrder);
        Priority.writeTo(this.priority, out);
        out.writeText(this.source);
        out.writeVLong(this.timeInQueue);
    }
}

