/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.document;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Blob.AnyToPDF")
public class AnyBlobToPDF {
    private static final Log log = LogFactory.getLog(AnyBlobToPDF.class);
    private static final Log sofficelog = LogFactory.getLog((String)"soffice");
    private static Map<String, Long> conversionsInProgress = new ConcurrentHashMap<String, Long>();
    private static Long retryTime = null;
    public static final String ID = "Blob.AnyToPDF";
    @Context
    protected ConversionService service;
    @Param(name="converterName", required=false)
    protected String converterName = "toutaticeAny2pdf";

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        if ("application/pdf".equals(bh.getBlob().getMimeType())) {
            return bh.getBlob();
        }
        Blob result = null;
        GregorianCalendar modDate = (GregorianCalendar)doc.getPropertyValue("dc:modified");
        HashMap<String, Long> cacheKeyParams = new HashMap<String, Long>();
        cacheKeyParams.put("modifiedOn", modDate.getTimeInMillis());
        long startConversionDate = new Date().getTime();
        if (AnyBlobToPDF.checkCurrentConversions(doc)) {
            return null;
        }
        if (sofficelog.isDebugEnabled()) {
            sofficelog.debug((Object)("Start conversion of " + doc.getTitle() + " " + doc.getPath()));
        }
        BlobHolder pdfBh = null;
        try {
            pdfBh = this.service.convert(this.converterName, bh, cacheKeyParams);
        }
        catch (ConversionException e) {
            sofficelog.error((Object)e);
        }
        if (pdfBh == null || pdfBh.getBlob() == null) {
            long elapsed = new Date().getTime() - startConversionDate;
            sofficelog.warn((Object)("Unable to convert " + doc.getTitle() + " " + doc.getPath() + " (elapsed time : " + elapsed + " ms.) "));
            return null;
        }
        if (sofficelog.isDebugEnabled()) {
            long elapsed = new Date().getTime() - startConversionDate;
            sofficelog.debug((Object)("End of conversion of " + doc.getTitle() + " " + doc.getPath() + " (elapsed time : " + elapsed + " ms.) "));
        }
        conversionsInProgress.remove(doc.getId());
        result = pdfBh.getBlob();
        String fname = result.getFilename();
        String filename = bh.getBlob().getFilename();
        if (filename != null && !filename.isEmpty()) {
            int pos = filename.lastIndexOf(46);
            if (pos > 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + ".pdf";
            result.setFilename(filename);
        } else if (fname != null && !fname.isEmpty()) {
            result.setFilename(fname);
        } else {
            result.setFilename("file");
        }
        result.setMimeType("application/pdf");
        return result;
    }

    private static synchronized boolean checkCurrentConversions(DocumentModel doc) {
        boolean isInProgress = conversionsInProgress.containsKey(doc.getId());
        if (!isInProgress) {
            conversionsInProgress.put(doc.getId(), new Date().getTime());
        } else {
            Long started = conversionsInProgress.get(doc.getId());
            Long elapsed = new Date().getTime() - started;
            if (elapsed > AnyBlobToPDF.getRetryTime()) {
                conversionsInProgress.put(doc.getId(), new Date().getTime());
                isInProgress = false;
            } else {
                sofficelog.warn((Object)(doc.getTitle() + " " + doc.getPath() + " is currently in conversion, since " + elapsed + "ms."));
            }
        }
        return isInProgress;
    }

    private static Long getRetryTime() {
        if (retryTime == null) {
            String property = Framework.getProperty((String)"ottc.converter.toutaticeAny2pdf.retryTime");
            if (property == null) {
                property = "1800";
            }
            retryTime = Long.parseLong(property) * 1000L;
        }
        return retryTime;
    }
}

