/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.trash;

import fr.toutatice.ecm.platform.automation.trash.AbstractTrashOperation;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.trash.TrashInfo;
import org.nuxeo.ecm.core.trash.TrashService;

@Operation(id="Document.PutDocumentInTrash", category="Document", label="PutDocumentInTrash", description="Put a document in trash.")
public class PutDocumentInTrash
extends AbstractTrashOperation {
    public static final String ID = "Document.PutDocumentInTrash";
    @Context
    protected CoreSession session;
    @Param(name="document", required=true)
    protected DocumentModel document;

    @OperationMethod
    public Object run() throws Exception {
        DocumentModelListImpl docs = new DocumentModelListImpl(1);
        docs.add((Object)this.document);
        return this.execute(this.session, (DocumentModelList)docs);
    }

    @OperationMethod
    public Object run(DocumentModel document) throws Exception {
        this.document = document;
        return this.run();
    }

    @Override
    public void invoke(TrashService service, TrashInfo info) throws Exception {
        if (info.forbidden > 0) {
            throw new Exception("Can not put in trash!!");
        }
        DocumentModel proxy = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)this.document, null, (boolean)true);
        if (proxy != null) {
            this.session.removeDocument(proxy.getRef());
        }
        service.trashDocuments(info.docs);
    }
}

