/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.users;

import java.util.Locale;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.ecm.platform.ui.select2.common.Select2Common;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="UserGroup.SuggestUserEntriesInWorkspace", category="Services", label="Get user/group suggestion having membership in workspace", description="Get user/group suggestion having membership in workspace on given document. This is returning a blob containing a serialized JSON array..", addToStudio=false)
public class SuggestUserEntriesInWorkspace {
    public static final String ID = "UserGroup.SuggestUserEntriesInWorkspace";
    @Context
    protected OperationContext ctx;
    @Context
    protected PermissionProvider permissionProvider;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="searchTerm", alias={"prefix"}, required=false)
    protected String prefix;
    @Param(name="documentId")
    protected DocumentModel document;
    @Param(name="permission")
    protected String permission;
    @Param(name="searchType", required=false)
    protected String searchType;
    @Param(name="groupRestriction", required=false)
    protected String groupRestriction;
    @Param(name="userSuggestionMaxSearchResults", required=false)
    protected Integer userSuggestionMaxSearchResults;
    @Param(name="firstLabelField", required=false)
    protected String firstLabelField;
    @Param(name="secondLabelField", required=false)
    protected String secondLabelField;
    @Param(name="thirdLabelField", required=false)
    protected String thirdLabelField;
    @Param(name="hideFirstLabel", required=false)
    protected boolean hideFirstLabel = false;
    @Param(name="hideSecondLabel", required=false)
    protected boolean hideSecondLabel = false;
    @Param(name="hideThirdLabel", required=false)
    protected boolean hideThirdLabel;
    @Param(name="displayEmailInSuggestion", required=false)
    protected boolean displayEmailInSuggestion;
    @Param(name="hideIcon", required=false)
    protected boolean hideIcon;
    @Context
    protected UserManager userManager;
    @Context
    protected DirectoryService directoryService;
    @Param(name="lang", required=false)
    protected String lang;

    @OperationMethod
    public Blob run() throws ClientException {
        SearchResult next;
        String searchBaseDn;
        boolean userOnly = false;
        boolean groupOnly = false;
        if (this.searchType != null && !this.searchType.isEmpty()) {
            if (this.searchType.equals("USER_TYPE")) {
                userOnly = true;
            } else if (this.searchType.equals("GROUP_TYPE")) {
                groupOnly = true;
            }
        }
        JSONArray result = new JSONArray();
        LDAPDirectory userDir = (LDAPDirectory)this.directoryService.getDirectory(this.userManager.getUserDirectoryName());
        LDAPDirectory groupDir = (LDAPDirectory)this.directoryService.getDirectory(this.userManager.getGroupDirectoryName());
        LDAPSession session = (LDAPSession)userDir.getSession();
        DirContext context = session.getContext();
        String workspaceId = this.getLdapWorkspaceId(this.document);
        String workspaceMemberDn = null;
        if (StringUtils.isNotBlank((String)workspaceId)) {
            try {
                searchBaseDn = groupDir.getConfig().getSearchBaseDn();
                String fieldId = groupDir.getFieldMapper().getBackendField("groupname");
                String fieldLabel = groupDir.getFieldMapper().getBackendField("grouplabel");
                String fieldWorkspaceId = groupDir.getFieldMapper().getBackendField("workspaceId");
                String fieldRole = groupDir.getFieldMapper().getBackendField("role");
                String fieldType = groupDir.getFieldMapper().getBackendField("type");
                StringBuilder sbSpaceGroup = new StringBuilder();
                sbSpaceGroup.append("(&");
                sbSpaceGroup.append("(").append(fieldWorkspaceId).append("=").append(workspaceId).append(")");
                sbSpaceGroup.append("(").append(fieldType).append("=").append("space_group").append(")");
                sbSpaceGroup.append(")");
                NamingEnumeration<SearchResult> search = context.search(searchBaseDn, sbSpaceGroup.toString(), groupDir.getSearchControls());
                while (search.hasMoreElements()) {
                    SearchResult next2 = search.next();
                    workspaceMemberDn = next2.getNameInNamespace();
                }
                StringBuilder sbAllGroup = new StringBuilder();
                sbAllGroup.append("(&");
                sbAllGroup.append("(").append(fieldWorkspaceId).append("=").append(workspaceId).append(")");
                if (StringUtils.isNotBlank((String)this.prefix)) {
                    sbAllGroup.append("(").append(fieldLabel).append("=").append(this.prefix).append("*)");
                }
                sbAllGroup.append(")");
                search = context.search(searchBaseDn, sbAllGroup.toString(), groupDir.getSearchControls());
                while (search.hasMoreElements()) {
                    next = search.next();
                    Attribute attrType = next.getAttributes().get(fieldType);
                    Attribute attrRole = next.getAttributes().get(fieldRole);
                    String label = "";
                    if (attrType.get(0).equals("space_group")) {
                        workspaceMemberDn = next.getNameInNamespace();
                        label = I18NUtils.getMessageString((String)"messages", (String)"label.search.allmembers", null, (Locale)this.getLocale());
                    } else if (attrType.get(0).equals("security_group")) {
                        if (attrRole.get(0).equals("READER")) {
                            label = I18NUtils.getMessageString((String)"messages", (String)"label.search.readers", null, (Locale)this.getLocale());
                        } else if (attrRole.get(0).equals("CONTRIBUTOR")) {
                            label = I18NUtils.getMessageString((String)"messages", (String)"label.search.contributors", null, (Locale)this.getLocale());
                        } else if (attrRole.get(0).equals("WRITER")) {
                            label = I18NUtils.getMessageString((String)"messages", (String)"label.search.writers", null, (Locale)this.getLocale());
                        } else if (attrRole.get(0).equals("ADMIN")) {
                            label = I18NUtils.getMessageString((String)"messages", (String)"label.search.admins", null, (Locale)this.getLocale());
                        } else if (attrRole.get(0).equals("OWNER")) {
                            label = I18NUtils.getMessageString((String)"messages", (String)"label.search.owners", null, (Locale)this.getLocale());
                        }
                    } else {
                        label = next.getAttributes().get(fieldLabel).get(0).toString();
                    }
                    if (userOnly) continue;
                    JSONObject obj = new JSONObject();
                    String groupId = next.getAttributes().get(fieldId).get(0).toString();
                    obj.put((Object)"id", (Object)groupId);
                    obj.put((Object)"displayLabel", (Object)label);
                    obj.put((Object)"type", (Object)"GROUP_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("group:" + groupId));
                    Select2Common.computeUserGroupIcon((JSONObject)obj, (boolean)this.hideIcon);
                    result.add((Object)obj);
                }
            }
            catch (NamingException e) {
                throw new ClientException((Throwable)e);
            }
        }
        if (!groupOnly) {
            try {
                searchBaseDn = userDir.getConfig().getSearchBaseDn();
                String fieldMemberOf = userDir.getFieldMapper().getBackendField("groups");
                String fieldId = userDir.getFieldMapper().getBackendField("username");
                String fieldFirstName = userDir.getFieldMapper().getBackendField("firstName");
                String fieldLastName = userDir.getFieldMapper().getBackendField("lastName");
                String fieldMail = userDir.getFieldMapper().getBackendField("email");
                StringBuilder subSb = new StringBuilder();
                subSb.append("(|");
                subSb.append("(").append(fieldFirstName).append("=").append(this.prefix).append("*)");
                subSb.append("(").append(fieldLastName).append("=").append(this.prefix).append("*)");
                subSb.append("(").append(fieldMail).append("=").append(this.prefix).append("*)");
                subSb.append(")");
                StringBuilder sb = new StringBuilder();
                sb.append("(&");
                sb.append(subSb.toString());
                if (workspaceMemberDn != null) {
                    sb.append("(").append(fieldMemberOf).append("=").append(workspaceMemberDn).append("*)");
                }
                sb.append(")");
                NamingEnumeration<SearchResult> search = context.search(searchBaseDn, sb.toString(), userDir.getSearchControls());
                while (search.hasMoreElements()) {
                    Attribute lastName;
                    next = search.next();
                    JSONObject obj = new JSONObject();
                    String userId = next.getAttributes().get(fieldId).get(0).toString();
                    obj.put((Object)"id", (Object)userId);
                    obj.put((Object)"type", (Object)"USER_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("user:" + userId));
                    Attribute firstName = next.getAttributes().get(fieldFirstName);
                    if (firstName != null) {
                        obj.put((Object)"firstName", firstName.get(0));
                    }
                    if ((lastName = next.getAttributes().get(fieldLastName)) != null) {
                        obj.put((Object)"lastName", lastName.get(0));
                    }
                    obj.put((Object)"email", next.getAttributes().get(fieldMail).get(0));
                    Select2Common.computeUserLabel((JSONObject)obj, (String)this.firstLabelField, (String)this.secondLabelField, (String)this.thirdLabelField, (boolean)this.hideFirstLabel, (boolean)this.hideSecondLabel, (boolean)this.hideThirdLabel, (boolean)this.displayEmailInSuggestion, (String)userId);
                    Select2Common.computeUserGroupIcon((JSONObject)obj, (boolean)this.hideIcon);
                    result.add((Object)obj);
                }
            }
            catch (NamingException e) {
                throw new ClientException((Throwable)e);
            }
        }
        return new StringBlob(result.toString(), "application/json");
    }

    private String getLdapWorkspaceId(DocumentModel document) {
        Path documentPath = document.getPath();
        while (documentPath != null) {
            DocumentModel parent = this.ctx.getCoreSession().getDocument((DocumentRef)new PathRef(documentPath.toString()));
            if (parent.hasSchema("webcontainer") && parent.getType().equals("Workspace")) {
                return parent.getPropertyValue("webc:url").toString();
            }
            documentPath = parent.getPath().removeLastSegments(1);
        }
        return null;
    }

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }
}

