/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.users;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.features.PrincipalHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.select2.common.Select2Common;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="UserGroup.SuggestUserEntriesWithPermission", category="Services", label="Get user/group suggestion having given permission on given document", description="Get user/group suggestion having given permission on given document. This is returning a blob containing a serialized JSON array..", addToStudio=false)
public class SuggestUserEntriesWithPermission {
    public static final String ID = "UserGroup.SuggestUserEntriesWithPermission";
    @Context
    protected OperationContext ctx;
    @Context
    protected PermissionProvider permissionProvider;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="searchTerm", alias={"prefix"}, required=false)
    protected String prefix;
    @Param(name="documentId")
    protected DocumentModel document;
    @Param(name="permission")
    protected String permission;
    @Param(name="searchType", required=false)
    protected String searchType;
    @Param(name="groupRestriction", required=false)
    protected String groupRestriction;
    @Param(name="userSuggestionMaxSearchResults", required=false)
    protected Integer userSuggestionMaxSearchResults;
    @Param(name="firstLabelField", required=false)
    protected String firstLabelField;
    @Param(name="secondLabelField", required=false)
    protected String secondLabelField;
    @Param(name="thirdLabelField", required=false)
    protected String thirdLabelField;
    @Param(name="hideFirstLabel", required=false)
    protected boolean hideFirstLabel = false;
    @Param(name="hideSecondLabel", required=false)
    protected boolean hideSecondLabel = false;
    @Param(name="hideThirdLabel", required=false)
    protected boolean hideThirdLabel;
    @Param(name="displayEmailInSuggestion", required=false)
    protected boolean displayEmailInSuggestion;
    @Param(name="hideIcon", required=false)
    protected boolean hideIcon;
    @Context
    protected UserManager userManager;
    @Context
    protected DirectoryService directoryService;
    @Param(name="lang", required=false)
    protected String lang;

    @OperationMethod
    public Blob run() throws ClientException {
        JSONArray result = new JSONArray();
        boolean isGroupRestriction = !StringUtils.isBlank((String)this.groupRestriction);
        boolean groupOnly = false;
        boolean userOnly = isGroupRestriction;
        CoreSession session = this.ctx.getCoreSession();
        if (!isGroupRestriction && this.searchType != null && !this.searchType.isEmpty()) {
            if (this.searchType.equals("USER_TYPE")) {
                userOnly = true;
            } else if (this.searchType.equals("GROUP_TYPE")) {
                groupOnly = true;
            }
        }
        try {
            Serializable value;
            String key;
            QName fieldName;
            JSONObject obj;
            Schema schema;
            DocumentModelList userList = null;
            DocumentModelList groupList = null;
            if (!groupOnly) {
                schema = this.schemaManager.getSchema(this.userManager.getUserSchemaName());
                userList = this.userManager.searchUsers(this.prefix);
                Directory userDir = this.directoryService.getDirectory(this.userManager.getUserDirectoryName());
                for (DocumentModel user : userList) {
                    NuxeoPrincipal principal = this.userManager.getPrincipal(user.getTitle());
                    if (!session.hasPermission((Principal)principal, this.document.getRef(), this.permission)) continue;
                    obj = new JSONObject();
                    for (Field field : schema.getFields()) {
                        fieldName = field.getName();
                        key = fieldName.getLocalName();
                        value = user.getPropertyValue(fieldName.getPrefixedName());
                        if (key.equals(userDir.getPasswordField())) continue;
                        obj.element(key, (Object)value);
                    }
                    String userId = user.getId();
                    obj.put((Object)"id", (Object)userId);
                    obj.put((Object)"type", (Object)"USER_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("user:" + (String)userId));
                    Select2Common.computeUserLabel((JSONObject)obj, (String)this.firstLabelField, (String)this.secondLabelField, (String)this.thirdLabelField, (boolean)this.hideFirstLabel, (boolean)this.hideSecondLabel, (boolean)this.hideThirdLabel, (boolean)this.displayEmailInSuggestion, (String)userId);
                    Select2Common.computeUserGroupIcon((JSONObject)obj, (boolean)this.hideIcon);
                    if (isGroupRestriction) {
                        user = this.userManager.getUserModel(userId);
                        UserAdapter userAdapter = (UserAdapter)user.getAdapter(UserAdapter.class);
                        List groups = userAdapter.getGroups();
                        if (groups == null || !groups.contains(this.groupRestriction)) continue;
                        result.add((Object)obj);
                        continue;
                    }
                    result.add((Object)obj);
                }
            }
            if (!userOnly) {
                schema = this.schemaManager.getSchema(this.userManager.getGroupSchemaName());
                groupList = this.userManager.searchGroups(this.prefix);
                List<String> groupsForPermission = this.getGroupsForPermission(this.document, this.permission);
                for (DocumentModel group : groupList) {
                    String groupName = (String)((Object)group.getPropertyValue("group:groupname"));
                    if (!groupsForPermission.contains(groupName)) continue;
                    obj = new JSONObject();
                    for (Field field : schema.getFields()) {
                        fieldName = field.getName();
                        key = fieldName.getLocalName();
                        value = group.getPropertyValue(fieldName.getPrefixedName());
                        obj.element(key, (Object)value);
                    }
                    String groupId = group.getId();
                    obj.put((Object)"id", (Object)groupId);
                    Select2Common.computeGroupLabel((JSONObject)obj, (String)groupId, (String)this.userManager.getGroupLabelField(), (boolean)this.hideFirstLabel);
                    obj.put((Object)"type", (Object)"GROUP_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("group:" + groupId));
                    Select2Common.computeUserGroupIcon((JSONObject)obj, (boolean)this.hideIcon);
                    result.add((Object)obj);
                }
            }
            int userSize = userList != null ? userList.size() : 0;
            int groupSize = groupList != null ? groupList.size() : 0;
            int totalSize = userSize + groupSize;
            if (this.userSuggestionMaxSearchResults != null && this.userSuggestionMaxSearchResults > 0 && (userSize > this.userSuggestionMaxSearchResults || groupSize > this.userSuggestionMaxSearchResults || totalSize > this.userSuggestionMaxSearchResults)) {
                throw new SizeLimitExceededException();
            }
        }
        catch (SizeLimitExceededException e) {
            return this.searchOverflowMessage();
        }
        return new StringBlob(result.toString(), "application/json");
    }

    protected List<String> getGroupsForPermission(DocumentModel document, String permission) {
        ArrayList<String> groups = new ArrayList<String>();
        PrincipalHelper principalHelper = new PrincipalHelper(this.userManager, this.permissionProvider);
        String[] perms = principalHelper.getPermissionsToCheck(permission);
        ACP acp = document.getACP();
        for (ACL acl : acp.getACLs()) {
            for (ACE ace : acl.getACEs()) {
                NuxeoGroup group;
                if (!ace.isGranted() || !this.permissionMatch(perms, ace.getPermission()) || (group = this.userManager.getGroup(ace.getUsername())) == null) continue;
                groups.add(group.getName());
            }
        }
        return groups;
    }

    public boolean permissionMatch(String[] perms, String perm) {
        for (String p : perms) {
            if (!p.equals(perm)) continue;
            return true;
        }
        return false;
    }

    private Blob searchOverflowMessage() {
        JSONArray result = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put((Object)"displayLabel", (Object)I18NUtils.getMessageString((String)"messages", (String)"label.security.searchOverFlow", (Object[])new Object[0], (Locale)this.getLocale()));
        result.add((Object)obj);
        return new StringBlob(result.toString(), "application/json");
    }

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }
}

