/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.blob;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

public class BlobHelper {
    private static final String DEFAULT_SCHEMA = "files:files";

    private BlobHelper() {
    }

    public static DocumentModel setBlobs(DocumentModel doc, BlobList blobs) {
        return BlobHelper.setBlobs(null, doc, blobs, DEFAULT_SCHEMA, false);
    }

    public static DocumentModel setBlobs(CoreSession session, DocumentModel doc, BlobList blobs, boolean save) {
        return BlobHelper.setBlobs(session, doc, blobs, DEFAULT_SCHEMA, save);
    }

    public static DocumentModel setBlobs(CoreSession session, DocumentModel doc, BlobList blobs, String xpath, boolean save) {
        if (CollectionUtils.isNotEmpty((Collection)blobs)) {
            ArrayList<HashMap> existingBlobs = (ArrayList<HashMap>)doc.getPropertyValue(xpath);
            if (existingBlobs == null) {
                existingBlobs = new ArrayList<HashMap>();
            }
            for (Blob blob : blobs) {
                HashMap blobProp = DocumentHelper.createBlobHolderMap((Blob)blob);
                existingBlobs.add(blobProp);
            }
            doc.setPropertyValue(xpath, (Serializable)existingBlobs);
            if (save) {
                session.saveDocument(doc);
            }
        }
        return doc;
    }
}

