/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeCommentsHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeNotifyEventHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;

@Operation(id="Document.TTCPPublish", category="Document", label="Publish a document locally", description="Publish the input document into the target section. Existing proxy is overrided if the override attribute is set. Return the created proxy.")
public class PublishDocument {
    public static final String ID = "Document.TTCPPublish";
    public static Log log = LogFactory.getLog(PublishDocument.class);
    public static final String DOCUMENT_SET_ON_LINE = "documentSetOnLine";
    @Context
    protected CoreSession session;
    @Param(name="target", required=true)
    protected DocumentModel target;
    @Param(name="override", required=false, values={"true"})
    protected boolean override = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        InnerSilentPublish runner = new InnerSilentPublish(this.session, doc);
        runner.silentRun(true);
        return runner.getProxy();
    }

    private class InnerSilentPublish
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel doc;
        private DocumentModel newProxy;

        public DocumentModel getProxy() {
            return this.newProxy;
        }

        public InnerSilentPublish(CoreSession session, DocumentModel doc) {
            super(session);
            this.doc = doc;
        }

        public void run() throws ClientException {
            this.newProxy = null;
            String formerProxyName = null;
            DocumentRef targetRef = PublishDocument.this.target.getRef();
            DocumentRef baseDocRef = this.doc.getRef();
            GregorianCalendar lastIssuedDate = null;
            if (!this.doc.isVersion()) {
                if ("project".equals(this.doc.getCurrentLifeCycleState())) {
                    this.doc.setPropertyValue("dc:valid", (Serializable)new Date());
                    this.session.saveDocument(this.doc);
                    this.session.followTransition(this.doc.getRef(), "approve");
                    this.doc.refresh(1, null);
                }
                if (!this.doc.isCheckedOut()) {
                    String label = this.doc.getVersionLabel();
                    VersionModelImpl vm = new VersionModelImpl();
                    vm.setLabel(label);
                    DocumentModel vdoc = this.session.getDocumentWithVersion(this.doc.getRef(), (VersionModel)vm);
                    if (null != vdoc && "project".equals(vdoc.getCurrentLifeCycleState())) {
                        this.session.followTransition(vdoc.getRef(), "approve");
                    }
                }
            }
            if (null != targetRef) {
                if (this.doc.isVersion()) {
                    String sourceDocId = this.doc.getSourceId();
                    baseDocRef = new IdRef(sourceDocId);
                }
                DocumentModelList proxies = this.session.getProxies(baseDocRef, targetRef);
                HashMap proxyComments = new HashMap();
                if (proxies != null && proxies.size() >= 1 && this.doc.isVersion() && PublishDocument.this.override) {
                    Iterator proxy = (DocumentModel)proxies.get(0);
                    proxyComments.putAll(ToutaticeCommentsHelper.getProxyComments((DocumentModel)proxy));
                }
                if (proxies != null && proxies.size() > 1) {
                    log.warn((Object)("Document " + this.doc.getPathAsString() + " has more than one local proxy. Deleting them."));
                }
                for (DocumentModel proxy : proxies) {
                    if (this.doc.isVersion() && PublishDocument.this.override) {
                        this.session.removeDocument(proxy.getRef());
                    }
                    GregorianCalendar issuedDate = (GregorianCalendar)proxy.getPropertyValue("dc:issued");
                    if (lastIssuedDate != null && !issuedDate.after(lastIssuedDate)) continue;
                    lastIssuedDate = issuedDate;
                }
                this.newProxy = this.session.publishDocument(this.doc, PublishDocument.this.target, PublishDocument.this.override);
                ToutaticeCommentsHelper.setComments((CoreSession)this.session, (DocumentModel)this.newProxy, proxyComments);
                this.newProxy.removeFacet("isLocalPublishLive");
                this.session.saveDocument(this.newProxy);
                if (!this.newProxy.getName().matches(".*\\.proxy$")) {
                    String newProxyName = this.doc.getName() + ".proxy";
                    if (StringUtils.isNotBlank(formerProxyName)) {
                        newProxyName = formerProxyName;
                    }
                    this.newProxy = this.session.move(this.newProxy.getRef(), targetRef, newProxyName);
                }
                if (PublishDocument.this.target.hasFacet("Orderable")) {
                    DocumentModel baseDoc = this.session.getDocument(baseDocRef);
                    this.session.orderBefore(targetRef, this.newProxy.getName(), baseDoc.getName());
                }
                boolean yetPublished = lastIssuedDate != null;
                GregorianCalendar issued = null;
                issued = this.doc.getPropertyValue("ttc:publicationDate") != null ? (GregorianCalendar)this.doc.getPropertyValue("ttc:publicationDate") : (!yetPublished ? new GregorianCalendar() : lastIssuedDate);
                if (issued != null) {
                    String srcDocId = this.newProxy.getSourceId();
                    DocumentModel srcDoc = this.session.getDocument((DocumentRef)new IdRef(srcDocId));
                    srcDoc.setPropertyValue("dc:issued", (Serializable)issued);
                    srcDoc = this.session.saveDocument(srcDoc);
                }
            } else {
                throw new ClientException("Failed to get the target document reference");
            }
            ToutaticeNotifyEventHelper.notifyEvent((CoreSession)this.session, (String)PublishDocument.DOCUMENT_SET_ON_LINE, (DocumentModel)this.doc, null);
        }
    }
}

