/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;

@Operation(id="Document.SetTags", category="Document", label="Set Document Tags", description="Sets a document tags. Replace the previous list of tags by the list.")
public class SetDocumentTags {
    public static final String ID = "Document.SetTags";
    private static final Log log = LogFactory.getLog(SetDocumentTags.class);
    @Context
    protected CoreSession session;
    @Context
    protected TagService tagService;
    @Param(name="labels", required=false, description="list of tag labels, if empty removes all current tags")
    protected StringList labels;
    @Param(name="username", required=false, description="username of the owner of the tags, if null the tags are global")
    protected String username;

    @OperationMethod
    public void run(DocumentModel doc) throws Exception {
        String docId = doc.getId();
        this.setLabels(docId);
    }

    @OperationMethod
    public void run(IdRef idRef) throws Exception {
        this.setLabels(idRef.toString());
    }

    private void setLabels(String docId) {
        log.info((Object)("SetDocumentTags> docId=" + docId + " tags=" + StringUtils.join((Collection)this.labels, (String)", ") + " username=" + this.username));
        List existingTags = this.tagService.getDocumentTags(this.session, docId, this.username);
        if (existingTags != null) {
            for (Tag tag : existingTags) {
                this.tagService.untag(this.session, docId, tag.getLabel(), this.username);
            }
        }
        if (this.labels != null) {
            for (String label : this.labels) {
                if (!StringUtils.isNotBlank((String)label)) continue;
                this.tagService.tag(this.session, docId, label, this.username);
            }
        }
        this.session.save();
    }
}

