/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.convert;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;
import org.nuxeo.runtime.api.Framework;

public class LibreOfficeCommandLineConverter
extends CommandLineBasedConverter {
    private static final String POOL_SIZE_PARAMETER = "EnvironmentPoolSize";
    private static final String TIMEOUT_DURATION_PARAMETER = "EnvironmentTimeoutDuration";
    private static int poolSize;
    private static String timeoutDuration;
    private static AtomicInteger instanceCounter;

    protected TTCCmdReturn execOnBlobTTC(String commandName, Map<String, Blob> blobParameters, Map<String, String> parameters) throws ConversionException {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        CmdParameters params = cles.getDefaultCmdParameters();
        ArrayList<String> filesToDelete = new ArrayList<String>();
        try {
            if (blobParameters != null) {
                for (String blobParamName : blobParameters.keySet()) {
                    Blob blob = blobParameters.get(blobParamName);
                    File file = File.createTempFile("cmdLineBasedConverter", "." + FilenameUtils.getExtension((String)blob.getFilename()));
                    blob.transferTo(file);
                    params.addNamedParameter(blobParamName, file);
                    filesToDelete.add(file.getAbsolutePath());
                }
            }
            if (parameters != null) {
                for (String paramName : parameters.keySet()) {
                    params.addNamedParameter(paramName, parameters.get(paramName));
                }
            }
            params.addNamedParameter("timeoutDuration", timeoutDuration);
            ExecResult result = cles.execCommand(commandName, params);
            if (!result.isSuccessful()) {
                throw result.getError();
            }
            TTCCmdReturn tTCCmdReturn = new TTCCmdReturn(params, result.getOutput());
            return tTCCmdReturn;
        }
        catch (CommandNotAvailable e) {
            throw new ConversionException("Unable to find targetCommand", (Exception)((Object)e));
        }
        catch (IOException | CommandException e) {
            throw new ConversionException("Error while converting via CommandLineService", (Exception)e);
        }
        finally {
            for (String fileToDelete : filesToDelete) {
                new File(fileToDelete).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        BlobHolder blobResult;
        String commandName = this.getCommandName(blobHolder, parameters);
        if (commandName == null) {
            throw new ConversionException("Unable to determine target CommandLine name");
        }
        instanceCounter.incrementAndGet();
        try {
            Map<String, Blob> blobParams = this.getCmdBlobParameters(blobHolder, parameters);
            Map<String, String> strParams = this.getCmdStringParameters(blobHolder, parameters);
            TTCCmdReturn result = this.execOnBlobTTC(commandName, blobParams, strParams);
            blobResult = this.buildResult(result.output, result.params);
        }
        finally {
            instanceCounter.decrementAndGet();
        }
        return blobResult;
    }

    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
        try {
            cmdBlobParams.put("inFilePath", blobHolder.getBlob());
        }
        catch (ClientException e) {
            throw new ConversionException("Unable to get Blob for holder", (Exception)((Object)e));
        }
        return cmdBlobParams;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        File envDir;
        HashMap<String, String> cmdStringParams = new HashMap<String, String>();
        String baseDir = this.getTmpDirectory(parameters);
        Path tmpPath = new Path(baseDir).append("soffice_" + System.currentTimeMillis());
        File outDir = new File(tmpPath.toString());
        if (!outDir.mkdir()) {
            throw new ConversionException("Unable to create tmp dir for transformer output");
        }
        cmdStringParams.put("outDirPath", outDir.getAbsolutePath());
        int envIndex = instanceCounter.get();
        if (envIndex < poolSize) {
            Path envPath = new Path(baseDir).append("sofficeUserEnv_" + String.valueOf(envIndex));
            envDir = new File(envPath.toString());
            if (!envDir.isDirectory() && !envDir.mkdir()) {
                throw new ConversionException("Unable to create tmp soffice user directory for transformer output");
            }
        } else {
            throw new ConversionException("LibreOffice user environment pool is full");
        }
        cmdStringParams.put("envDirPath", envDir.getAbsolutePath());
        return cmdStringParams;
    }

    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParams) throws ConversionException {
        String outputPath = (String)cmdParams.getParameters().get("outDirPath");
        File outputDir = new File(outputPath);
        File[] files = outputDir.listFiles();
        ArrayList<FileBlob> blobs = new ArrayList<FileBlob>();
        for (File file : files) {
            FileBlob blob = new FileBlob(file);
            blob.setFilename(file.getName());
            if (file.getName().equalsIgnoreCase("index.html")) {
                blobs.add(0, blob);
                continue;
            }
            blobs.add(blob);
        }
        return new SimpleCachableBlobHolder(blobs);
    }

    public void init(ConverterDescriptor descriptor) {
        this.initParameters = descriptor.getParameters();
        if (this.initParameters == null) {
            this.initParameters = new HashMap();
        }
        poolSize = Integer.valueOf((String)this.initParameters.get(POOL_SIZE_PARAMETER));
        timeoutDuration = (String)this.initParameters.get(TIMEOUT_DURATION_PARAMETER);
        instanceCounter = new AtomicInteger();
        this.getCommandLineService();
    }

    protected class TTCCmdReturn {
        protected final CmdParameters params;
        protected final List<String> output;

        protected TTCCmdReturn(CmdParameters params, List<String> output) {
            this.params = params;
            this.output = output;
        }
    }
}

