/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.executors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.EnvironmentDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.ShellExecutor;
import org.nuxeo.log4j.ThreadedStreamGobbler;

public class TimeoutShellExecutor
extends ShellExecutor {
    private static final Log log = LogFactory.getLog(ShellExecutor.class);
    public static final String TIMEOUT_SHELL_EXECUTOR = "TimeoutShellExecutor";

    public ExecResult exec(CommandLineDescriptor cmdDesc, CmdParameters params, EnvironmentDescriptor env) {
        ThreadedStreamGobbler err;
        ThreadedStreamGobbler out;
        Process p1;
        Object[] cmd;
        long t0 = System.currentTimeMillis();
        List output = Collections.synchronizedList(new ArrayList());
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                Object[] paramsArray = TimeoutShellExecutor.getParametersArray((CommandLineDescriptor)cmdDesc, (CmdParameters)params);
                cmd = new String[]{"cmd", "/C", cmdDesc.getCommand()};
                cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])paramsArray);
            } else {
                String paramsString = TimeoutShellExecutor.getParametersString((CommandLineDescriptor)cmdDesc, (CmdParameters)params);
                cmd = new String[]{"/bin/sh", "-c", cmdDesc.getCommand() + " " + paramsString};
            }
        }
        catch (IllegalArgumentException e) {
            return new ExecResult(cmdDesc.getCommand(), (Exception)e);
        }
        String commandLine = StringUtils.join((Object[])cmd, (String)" ");
        HashMap paramsValues = params.getCmdParameters();
        CmdParameters.CmdParameter timeoutDurationP = (CmdParameters.CmdParameter)paramsValues.get("timeoutDuration");
        Long timeoutDuration = null;
        if (timeoutDurationP != null) {
            timeoutDuration = NumberUtils.toLong((String)timeoutDurationP.getValue());
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running system command: " + commandLine));
            }
            ProcessBuilder processBuilder = new ProcessBuilder((String[])cmd).directory(new File(env.getWorkingDirectory()));
            processBuilder.environment().putAll(env.getParameters());
            p1 = processBuilder.start();
        }
        catch (IOException e) {
            return new ExecResult(commandLine, (Exception)e);
        }
        if (cmdDesc.getReadOutput()) {
            out = new ThreadedStreamGobbler(p1.getInputStream(), output);
            err = new ThreadedStreamGobbler(p1.getErrorStream(), output);
        } else {
            out = new ThreadedStreamGobbler(p1.getInputStream(), 2);
            err = new ThreadedStreamGobbler(p1.getErrorStream(), 5);
        }
        err.start();
        out.start();
        int exitCode = 0;
        try {
            boolean finished;
            exitCode = timeoutDuration != null && timeoutDuration > 0L ? ((finished = this.waitFor(p1, timeoutDuration, TimeUnit.SECONDS)) ? p1.exitValue() : 124) : p1.waitFor();
            out.join();
            err.join();
        }
        catch (InterruptedException e) {
            return new ExecResult(commandLine, (Exception)e);
        }
        long t1 = System.currentTimeMillis();
        return new ExecResult(commandLine, output, t1 - t0, exitCode);
    }

    private boolean waitFor(Process p1, long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        long rem = unit.toNanos(timeout);
        while (true) {
            try {
                p1.exitValue();
                return true;
            }
            catch (IllegalThreadStateException ex) {
                if (rem <= 0L) continue;
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                if ((rem = unit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L) continue;
                return false;
            }
            break;
        }
    }
}

