/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.freemarker;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.services.permalink.PermaLinkService;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.nuxeo.ecm.automation.features.PlatformFunctions;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeFunctions
extends PlatformFunctions {
    private static final String PROTOCOL_BASE_URL = "http://";
    private static final String TRUNCATED_HTML_SUFFIX = "<span>&nbsp;... </span>";
    private static final String TRUNCATED_TEXT_SUFFIX = " ...";
    private static CommentManager commentManager;
    private static PermaLinkService permaLinkService;

    public String getDownloadFileUrl(DocumentModel doc, String xpath) throws PropertyException, ClientException {
        BlobProperty blob = (BlobProperty)doc.getProperty(xpath);
        String filename = ((SQLBlob)blob.getValue()).getFilename();
        String url = DocumentModelFunctions.fileUrl((String)"downloadFile", (DocumentModel)doc, (String)xpath, (String)filename);
        return url;
    }

    public String getPermalink(DocumentModel doc) throws PropertyException, ClientException {
        String url = "";
        if (ToutaticeDocumentHelper.isVisibleInPortal(doc, doc.getCoreSession())) {
            if (null == permaLinkService) {
                try {
                    permaLinkService = (PermaLinkService)Framework.getService(PermaLinkService.class);
                }
                catch (Exception e) {
                    throw new WebException("Unable to get publicationService");
                }
            }
            url = permaLinkService.getPermalink(doc);
        }
        return url;
    }

    public String getPortalHost(DocumentModel doc) {
        String host = "";
        if (ToutaticeDocumentHelper.isVisibleInPortal(doc, doc.getCoreSession())) {
            if (null == permaLinkService) {
                try {
                    permaLinkService = (PermaLinkService)Framework.getService(PermaLinkService.class);
                }
                catch (Exception e) {
                    throw new WebException("Unable to get publicationService");
                }
            }
            host = permaLinkService.getPortalHost();
        }
        return host;
    }

    public String getShortPortalHost(String portalHost) {
        String shortHost = "";
        if (StringUtils.isNotBlank((String)portalHost)) {
            shortHost = StringUtils.substring((String)portalHost, (int)PROTOCOL_BASE_URL.length());
        }
        return shortHost;
    }

    public String getDocumentComments(DocumentModel doc, Integer noComment) throws Exception {
        String res = "";
        if (commentManager == null) {
            commentManager = this.getCommentManager();
        }
        List lstComments = commentManager.getComments(doc);
        int idxComment = lstComments.size() - 1;
        if (noComment != null && noComment < lstComments.size()) {
            idxComment = noComment;
        }
        DocumentModel derComment = (DocumentModel)lstComments.get(idxComment);
        res = (String)((Object)derComment.getPropertyValue("comment:text"));
        return res;
    }

    private CommentManager getCommentManager() throws Exception {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        if (commentManager == null) {
            throw new WebException("Unable to get commentManager");
        }
        return commentManager;
    }

    public String extractTextFromHTML(String html) {
        return Jsoup.parse((String)html).text();
    }

    public String truncateTextFromHTML(String html, int nbChars) {
        String text = this.extractTextFromHTML(html);
        if (text != null) {
            if (StringUtils.endsWith((String)text, (String)TRUNCATED_TEXT_SUFFIX)) {
                text = StringUtils.substringBeforeLast((String)text, (String)TRUNCATED_TEXT_SUFFIX);
            }
            if (text.length() > nbChars) {
                text = StringUtils.substring((String)text, (int)0, (int)(nbChars - 1)).concat(TRUNCATED_TEXT_SUFFIX);
            }
        }
        return text;
    }

    @Deprecated
    public String truncateHTML(String html, int nbChars) {
        Document document;
        Elements body;
        Element content;
        String text;
        String truncatedHtml = html;
        if (html != null && (text = (content = (body = (document = Jsoup.parse((String)html)).getElementsByTag("body")).first()).text()) != null) {
            Elements finalElements;
            Elements elements = content.children();
            boolean toTruncate = text.length() > nbChars;
            for (int index = elements.size(); text.length() > nbChars && index > 0; --index) {
                Element lastElement = elements.get(index - 1);
                String innerText = lastElement.ownText();
                if (StringUtils.isNotBlank((String)innerText)) {
                    if (innerText.length() > nbChars) {
                        innerText = StringUtils.substring((String)innerText, (int)0, (int)(nbChars - 1));
                        lastElement.empty();
                        lastElement.append(innerText);
                        if (content.text().length() > nbChars) {
                            lastElement.remove();
                        }
                    } else {
                        lastElement.remove();
                    }
                } else {
                    Elements children = lastElement.children();
                    if (!children.isEmpty()) {
                        String childTruncHtml = this.truncateHTML(lastElement.html(), nbChars);
                        if (childTruncHtml != null) {
                            lastElement.empty();
                            lastElement.append(StringUtils.substringBeforeLast((String)childTruncHtml, (String)TRUNCATED_HTML_SUFFIX));
                        }
                    } else {
                        lastElement.remove();
                    }
                }
                text = content.text();
            }
            if (toTruncate && StringUtils.isNotBlank((String)truncatedHtml) && (finalElements = content.getAllElements()).size() > 0) {
                finalElements.get(finalElements.size() - 1).append(TRUNCATED_HTML_SUFFIX);
            }
            truncatedHtml = content.html();
        }
        return truncatedHtml;
    }

    public String getUserFullName(String username) {
        String fullName = "";
        try {
            NuxeoPrincipal principal = super.getUserManager().getPrincipal(username);
            if (principal != null) {
                fullName = principal.getFirstName().concat(" ").concat(principal.getLastName());
            }
        }
        catch (Exception e) {
            return fullName;
        }
        return fullName;
    }

    public String defaultIfBlank(String str, String defaultStr) {
        return StringUtils.defaultIfBlank((String)str, (String)defaultStr);
    }
}

