/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.constants.ToutaticeGlobalConst;
import fr.toutatice.ecm.platform.core.helper.ToutaticeFilter;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class ToutaticeDocumentHelper {
    private static final Log log = LogFactory.getLog(ToutaticeDocumentHelper.class);
    private static final String MEDIALIB = "MediaLibrary";

    private ToutaticeDocumentHelper() {
    }

    public static DocumentModel getUnrestrictedDocument(CoreSession session, String id) throws ClientException {
        GetUnrestrictedDocument getter = new GetUnrestrictedDocument(session, id);
        getter.runUnrestricted();
        return getter.getDocument();
    }

    public static DocumentModel getUnrestrictedParent(CoreSession session, DocumentModel document) {
        DocumentModel parent = null;
        if (document != null) {
            GetUnresrictedParent runner = new GetUnresrictedParent(session, document);
            runner.runUnrestricted();
            parent = runner.get();
        }
        return parent;
    }

    public static DocumentModel getUnrestrictedParent(DocumentModel document) {
        DocumentModel parent = null;
        if (document != null) {
            GetUnresrictedParent runner = new GetUnresrictedParent(document.getCoreSession(), document);
            runner.runUnrestricted();
            parent = runner.get();
        }
        return parent;
    }

    public static Serializable getUnrestrictedProperty(CoreSession session, String docId, String xpathProperty, boolean getValue) {
        GetUnrestrictedProperty getter = new GetUnrestrictedProperty(session, docId, xpathProperty, getValue);
        getter.runUnrestricted();
        return getter.getProperty();
    }

    public static Serializable getUnrestrictedProperty(CoreSession session, String docId, String xpathProperty) {
        GetUnrestrictedProperty getter = new GetUnrestrictedProperty(session, docId, xpathProperty, true);
        getter.runUnrestricted();
        return getter.getProperty();
    }

    public static void saveDocumentSilently(CoreSession session, DocumentModel document, boolean unrestricted) {
        SilentSave save = new SilentSave(session, document);
        save.silentRun(unrestricted, ToutaticeGlobalConst.EVENT_N_VERSIONING_FILTERD_SERVICE);
    }

    public static void saveDocumentSilently(CoreSession session, DocumentModel document, List<Class<?>> services, boolean unrestricted) {
        SilentSave save = new SilentSave(session, document);
        save.silentRun(unrestricted, services);
    }

    public static void saveDocumentWithNoVersioning(CoreSession session, DocumentModel document, boolean unrestricted) {
        SilentSave save = new SilentSave(session, document);
        save.silentRun(unrestricted, ToutaticeGlobalConst.VERSIONING_FILTERD_SERVICE);
    }

    public static void removeDocumentSilently(CoreSession session, DocumentModel document, boolean unrestricted) {
        SilentRemoveRunner deleter = new SilentRemoveRunner(session, document.getRef());
        deleter.silentRun(unrestricted, ToutaticeGlobalConst.EVENT_N_VERSIONING_FILTERD_SERVICE);
    }

    public static boolean isEmptyDocumentModel(DocumentModel document) {
        return document.getId() == null;
    }

    public static DocumentModel getLatestDocumentVersion(DocumentModel document, CoreSession session) {
        DocumentModel latestDoc;
        block5: {
            latestDoc = null;
            if (null != document && null != session) {
                try {
                    if ("approved".equals(document.getCurrentLifeCycleState())) {
                        latestDoc = document;
                        break block5;
                    }
                    List versionDocList = session.getVersions(document.getRef());
                    Collections.sort(versionDocList, new DocumentVersionComparator());
                    for (int i = 0; i < versionDocList.size(); ++i) {
                        DocumentModel versionDoc = (DocumentModel)versionDocList.get(i);
                        if (!"approved".equals(versionDoc.getCurrentLifeCycleState())) continue;
                        latestDoc = versionDoc;
                        break;
                    }
                }
                catch (ClientException e) {
                    log.debug((Object)("Failed to get the latest version of the document '" + document.getName() + "', error: " + e.getMessage()));
                }
            }
        }
        return latestDoc;
    }

    public static VersionModel getVersionModel(DocumentModel version) throws DocumentException {
        VersionModelImpl versionModel = new VersionModelImpl();
        versionModel.setId(version.getId());
        versionModel.setLabel(version.getVersionLabel());
        return versionModel;
    }

    public static DocumentModelList getParentList(CoreSession session, DocumentModel document, Filter filter, boolean runInUnrestrictedMode) {
        return ToutaticeDocumentHelper.getParentList(session, document, filter, runInUnrestrictedMode, false);
    }

    public static DocumentModelList getParentList(CoreSession session, DocumentModel document, Filter filter, boolean runInUnrestrictedMode, boolean immediateOnly) {
        return ToutaticeDocumentHelper.getParentList(session, document, filter, runInUnrestrictedMode, immediateOnly, false);
    }

    public static DocumentModelList getParentList(CoreSession session, DocumentModel document, Filter filter, boolean runInUnrestrictedMode, boolean immediateOnly, boolean thisInluded) {
        DocumentModelList parent = null;
        try {
            UnrestrictedGetParentsListRunner runner = new UnrestrictedGetParentsListRunner(session, document, filter, immediateOnly, thisInluded);
            if (runInUnrestrictedMode) {
                runner.runUnrestricted();
            } else {
                runner.run();
            }
            parent = runner.getParentList();
        }
        catch (ClientException e) {
            log.warn((Object)("Failed to get the parent for the current document, error: " + e.getMessage()));
        }
        return parent;
    }

    public static DocumentModelList getParentSpaceList(CoreSession session, DocumentModel document, boolean runInUnrestrictedMode, boolean immediateOnly) {
        return ToutaticeDocumentHelper.getParentSpaceList(session, document, runInUnrestrictedMode, immediateOnly, false);
    }

    public static DocumentModelList getParentSpaceList(CoreSession session, DocumentModel document, boolean runInUnrestrictedMode, boolean immediateOnly, boolean thisIncluded) {
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel document) {
                boolean res = false;
                if (ToutaticeDocumentHelper.isASpaceDocument(document)) {
                    res = true;
                }
                return res;
            }
        };
        return ToutaticeDocumentHelper.getParentList(session, document, filter, runInUnrestrictedMode, immediateOnly, thisIncluded);
    }

    public static Map<String, Property> getPropertiesParentDoc(CoreSession session, DocumentModel document, List<String> lstXpaths, Filter filter, boolean runInUnrestrictedMode, boolean thisIncluded) {
        Map<String, Property> mapPpty = null;
        try {
            GetParentPropertiesRunner runner = new GetParentPropertiesRunner(session, document, lstXpaths, filter, runInUnrestrictedMode, thisIncluded);
            if (runInUnrestrictedMode) {
                runner.runUnrestricted();
            } else {
                runner.run();
            }
            mapPpty = runner.getProperties();
        }
        catch (ClientException e) {
            log.warn((Object)("Failed to get the parent for the current document, error: " + e.getMessage()));
        }
        return mapPpty;
    }

    public static DocumentModel getWorkspace(CoreSession session, DocumentModel document, boolean unrestricted) {
        Filter wsFiler = new Filter(){

            public boolean accept(DocumentModel docModel) {
                return "Workspace".equals(docModel.getType());
            }
        };
        DocumentModelList parentWsList = ToutaticeDocumentHelper.getParentList(session, document, wsFiler, unrestricted, true, true);
        if (parentWsList != null && parentWsList.size() > 0) {
            return (DocumentModel)parentWsList.get(0);
        }
        return null;
    }

    public static String getSpaceID(CoreSession session, DocumentModel document, boolean runInUnrestrictedMode) throws ClientException, PropertyException {
        String spaceId = "";
        if ("UserWorkspace".equals(document.getType())) {
            spaceId = document.getTitle().toLowerCase();
        } else {
            DocumentModelList spaceParentList = ToutaticeDocumentHelper.getParentSpaceList(session, document, runInUnrestrictedMode, true);
            if (spaceParentList != null && !spaceParentList.isEmpty()) {
                DocumentModel space = (DocumentModel)spaceParentList.get(0);
                spaceId = "UserWorkspace".equals(space.getType()) ? space.getTitle().toLowerCase() : space.getId();
            }
        }
        return spaceId;
    }

    public static DocumentModel getDomain(CoreSession session, DocumentModel document, boolean runInUnrestrictedMode) throws ClientException {
        DocumentModel domain = null;
        DocumentModelList DomainList = ToutaticeDocumentHelper.getParentList(session, document, new Filter(){

            public boolean accept(DocumentModel docModel) {
                return "Domain".equals(docModel.getType());
            }
        }, runInUnrestrictedMode, true, true);
        if (null != DomainList && !DomainList.isEmpty()) {
            domain = (DocumentModel)DomainList.get(0);
        }
        return domain;
    }

    public static DocumentModelList getParentPublishSpaceList(CoreSession session, DocumentModel document, boolean runInUnrestrictedMode, boolean immediateOnly) {
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel document) {
                boolean status = false;
                try {
                    status = ToutaticeDocumentHelper.isAPublicationSpaceDocument(document);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to filter the publish space documents, error: " + e.getMessage()));
                    status = false;
                }
                return status;
            }
        };
        return ToutaticeDocumentHelper.getParentList(session, document, filter, runInUnrestrictedMode, immediateOnly, true);
    }

    public static String[] filterLifeCycleStateDocuments(CoreSession session, String[] sectionIdList, List<String> acceptedStates, List<String> excludedStates) {
        ArrayList<String> filteredSectionsList = new ArrayList<String>();
        try {
            if (null != sectionIdList && 0 < sectionIdList.length) {
                LifeCycleFilter lcFilter = new LifeCycleFilter(acceptedStates, excludedStates);
                for (String sectionId : sectionIdList) {
                    DocumentModel section = session.getDocument((DocumentRef)new IdRef(sectionId));
                    if (!lcFilter.accept(section)) continue;
                    filteredSectionsList.add(sectionId);
                }
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to filter the active sections, error: " + e.getMessage()));
        }
        return filteredSectionsList.toArray(new String[filteredSectionsList.size()]);
    }

    public static DocumentModel getProxy(CoreSession session, DocumentModel document, String permission) throws ClientException {
        return ToutaticeDocumentHelper.getProxy(session, document, permission, true);
    }

    public static DocumentModel getProxy(CoreSession session, DocumentModel document, String permission, boolean unrestricted) throws ClientException {
        DocumentModel proxy = null;
        DocumentModelList proxies = ToutaticeDocumentHelper.getProxies(session, document, ToutaticeGlobalConst.CST_TOUTATICE_PROXY_LOOKUP_SCOPE.LOCAL, permission, unrestricted);
        if (null != proxies && 0 < proxies.size()) {
            proxy = (DocumentModel)proxies.get(0);
            if (StringUtils.isNotBlank((String)permission) && !session.hasPermission(proxy.getRef(), permission)) {
                Principal principal = session.getPrincipal();
                throw new DocumentSecurityException("The user '" + principal.getName() + "' has not the permission '" + permission + "' on the proxy of document '" + document.getTitle() + "'");
            }
        }
        return proxy;
    }

    public static DocumentModelList getProxies(CoreSession session, DocumentModel document, ToutaticeGlobalConst.CST_TOUTATICE_PROXY_LOOKUP_SCOPE scope, String permission, boolean unrestricted) throws ClientException {
        DocumentModelListImpl proxies = null;
        if (null != document) {
            if (document.isProxy()) {
                proxies = new DocumentModelListImpl();
                proxies.add((Object)document);
            } else {
                UnrestrictedGetProxyRunner runner = new UnrestrictedGetProxyRunner(session, document, scope);
                if (unrestricted) {
                    runner.runUnrestricted();
                } else {
                    runner.run();
                }
                proxies = runner.getProxies();
            }
        }
        return proxies;
    }

    public static String getProxyVersion(CoreSession session, DocumentModel document) throws ClientException {
        String proxyVersion = null;
        DocumentModel proxy = ToutaticeDocumentHelper.getProxy(session, document, null);
        if (null != proxy) {
            UnrestrictedGetProxyVersionLabelRunner runner = new UnrestrictedGetProxyVersionLabelRunner(session, proxy);
            runner.runUnrestricted();
            proxyVersion = runner.getVersionLabel();
        }
        return proxyVersion;
    }

    public static boolean isVisibleInPortal(DocumentModel doc, CoreSession session) throws ClientException {
        DocumentModelList spaceDocsList;
        boolean res = false;
        boolean bl = res = null != ToutaticeDocumentHelper.getProxy(session, doc, "Read");
        if (!res && (spaceDocsList = ToutaticeDocumentHelper.getParentSpaceList(session, doc, true, true, true)) != null && !spaceDocsList.isEmpty()) {
            DocumentModel space = (DocumentModel)spaceDocsList.get(0);
            res = ToutaticeDocumentHelper.isAWorkSpaceLikeDocument(space) || ToutaticeDocumentHelper.isAPublicationSpaceDocument(space);
        }
        return res;
    }

    public static boolean isASpaceDocument(DocumentModel document) {
        return document.hasFacet("Space");
    }

    public static boolean isASuperSpaceDocument(DocumentModel document) {
        return document.hasFacet("SuperSpace");
    }

    public static boolean isAPublicationSpaceDocument(DocumentModel document) {
        boolean status = false;
        if (document.hasFacet("TTCPublishSpace")) {
            status = true;
        }
        return status;
    }

    public static boolean isAWorkSpaceLikeDocument(DocumentModel document) {
        return "Workspace".equals(document.getType()) || "UserWorkspace".equals(document.getType()) || ToutaticeDocumentHelper.isSubTypeOf(document, "Workspace");
    }

    public static boolean isWorkspace(DocumentModel document) {
        return "Workspace".equals(document.getType());
    }

    public static boolean isSubTypeOf(DocumentModel document, String type) {
        Type superType;
        DocumentType documentType = document.getDocumentType();
        if (documentType != null && (superType = documentType.getSuperType()) != null) {
            return StringUtils.equals((String)type, (String)superType.getName());
        }
        return false;
    }

    public static boolean isInPublishSpace(CoreSession session, DocumentModel document) {
        DocumentModelList parentPublishSpaceList = ToutaticeDocumentHelper.getParentPublishSpaceList(session, document, true, true);
        return CollectionUtils.isNotEmpty((Collection)parentPublishSpaceList);
    }

    public static boolean isInWorkspaceLike(CoreSession session, DocumentModel document) {
        DocumentModelList spaceDocsList = ToutaticeDocumentHelper.getParentSpaceList(session, document, true, true, true);
        if (CollectionUtils.isNotEmpty((Collection)spaceDocsList)) {
            DocumentModel space = (DocumentModel)spaceDocsList.get(0);
            return ToutaticeDocumentHelper.isAWorkSpaceLikeDocument(space);
        }
        return false;
    }

    public static int getSameDocsCount(CoreSession session, DocumentModel document, Filter filter) {
        int count = 0;
        try {
            UnrestrictedGetSameDocsListRunner runner = new UnrestrictedGetSameDocsListRunner(session, document, filter);
            runner.runUnrestricted();
            count = runner.getCount();
        }
        catch (ClientException e) {
            log.error((Object)("Failed to get the same document of one folder, error: " + e.getMessage()));
        }
        return count;
    }

    public static ACL getDocumentACL(CoreSession session, DocumentModel doc, String aclName, ToutaticeFilter<ACE> filter) throws ClientException {
        ACLImpl res = new ACLImpl();
        if (StringUtils.isBlank((String)aclName)) {
            aclName = "local";
        }
        ACP acp = doc.getACP();
        ACL[] aclList = null;
        if ("*".equals(aclName)) {
            aclList = acp.getACLs();
        } else {
            ACL acl = acp.getACL(aclName);
            if (null != acl) {
                aclList = new ACLImpl[]{acl};
            }
        }
        if (null != aclList) {
            for (ACL acl : aclList) {
                for (ACE ace : acl.getACEs()) {
                    if (filter != null && !filter.accept(ace)) continue;
                    res.add((Object)ace);
                }
            }
        }
        return res;
    }

    public static void setACE(CoreSession session, DocumentRef ref, ACE ace) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl("local");
        acp.addACL((ACL)acl);
        acl.add((Object)ace);
        session.setACP(ref, (ACP)acp, false);
    }

    public static boolean hasView(DocumentModel document, String viewId) {
        boolean status = false;
        if (null != document) {
            TypeInfo typeInfo = (TypeInfo)document.getAdapter(TypeInfo.class);
            String chosenView = typeInfo.getView(viewId);
            status = chosenView != null;
        }
        return status;
    }

    @Deprecated
    public static Object callOperation(AutomationService automation, OperationContext ctx, String operationId, Map<String, Object> parameters) throws Exception {
        InvokableMethod operationMethod = ToutaticeDocumentHelper.getRunMethod(automation, operationId);
        Object operationRes = operationMethod.invoke(ctx, parameters);
        return operationRes;
    }

    public static boolean isRuntimeDocument(DocumentModel document) {
        return document.hasFacet("SystemDocument") || document.hasFacet("HiddenInNavigation");
    }

    private static InvokableMethod getRunMethod(AutomationService automation, String operationId) throws SecurityException, NoSuchMethodException, OperationNotFoundException {
        Method method;
        OperationType opType = automation.getOperation(operationId);
        try {
            method = opType.getType().getMethod("run", null);
        }
        catch (NoSuchMethodException nsme) {
            Class[] tabArg = new Class[]{DocumentModel.class};
            method = opType.getType().getMethod("run", tabArg);
        }
        OperationMethod anno = method.getAnnotation(OperationMethod.class);
        return new InvokableMethod(opType, method, anno);
    }

    public static DocumentModel getMediaSpace(DocumentModel doc, CoreSession session) throws ClientException {
        DocumentModel mediaSpace = null;
        DocumentModel currentDomain = ToutaticeDocumentHelper.getDomain(session, doc, true);
        if (currentDomain != null) {
            String searchMediaLibraries = "ecm:primaryType = 'MediaLibrary' and ecm:path startswith '" + currentDomain.getPathAsString() + "' and ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState!='deleted'";
            String queryMediaLibraries = String.format("SELECT * FROM Document WHERE %s", searchMediaLibraries);
            DocumentModelList query = session.query(queryMediaLibraries);
            mediaSpace = query.size() < 1 || query.size() > 1 ? null : (DocumentModel)query.get(0);
        } else {
            log.warn((Object)("CurrentDomain not available " + doc.getTitle()));
        }
        return mediaSpace;
    }

    public static DocumentModelList getRemotePublishedDocuments(CoreSession session, DocumentModel document) {
        DocumentModelList remoteProxiesFound;
        DocumentModelListImpl remoteProxies = new DocumentModelListImpl();
        if (!ToutaticeDocumentHelper.isInPublishSpace(session, document) && CollectionUtils.isNotEmpty((Collection)(remoteProxiesFound = ToutaticeDocumentHelper.getProxies(session, document, ToutaticeGlobalConst.CST_TOUTATICE_PROXY_LOOKUP_SCOPE.GLOBAL, "", false)))) {
            remoteProxies.addAll((Collection)remoteProxiesFound);
        }
        return remoteProxies;
    }

    public static boolean isDocStillExists(CoreSession session, DocumentModel document) throws ClientException {
        boolean exists = false;
        if (document != null) {
            try {
                session.getDocument(document.getRef());
                exists = true;
            }
            catch (ClientException ce) {
                if (ce.getCause() instanceof NoSuchDocumentException) {
                    exists = false;
                }
                throw ce;
            }
        }
        return exists;
    }

    public static boolean isRemoteProxy(DocumentModel document) {
        return document.isProxy() && !StringUtils.endsWith((String)document.getName(), (String)".proxy");
    }

    public static boolean isLocaProxy(DocumentModel document) {
        return document.isProxy() && StringUtils.endsWith((String)document.getName(), (String)".proxy");
    }

    public static boolean isBeingModified(CoreSession session, DocumentModel document) {
        boolean is = false;
        String versionLabel = document.getVersionLabel();
        DocumentModel lastDocumentVersion = session.getLastDocumentVersion(document.getRef());
        if (lastDocumentVersion != null) {
            String lastDocumentVersionLabel = lastDocumentVersion.getVersionLabel();
            is = !StringUtils.equals((String)versionLabel, (String)lastDocumentVersionLabel);
        }
        return is;
    }

    private static class UnrestrictedGetSameDocsListRunner
    extends UnrestrictedSessionRunner {
        private int count = 0;
        private Filter filter = null;
        private DocumentModel document;

        public int getCount() {
            return this.count;
        }

        protected UnrestrictedGetSameDocsListRunner(CoreSession session, DocumentModel document, Filter filter) {
            super(session);
            this.filter = filter;
            this.document = document;
        }

        public void run() throws ClientException {
            String docTitle = this.document.getTitle();
            DocumentModel docParent = this.session.getParentDocument(this.document.getRef());
            DocumentModelList rs = this.session.query("SELECT * FROM " + this.document.getType() + " WHERE ecm:parentId = '" + docParent.getId() + "' " + "AND ecm:mixinType != 'HiddenInNavigation' " + "AND ecm:isCheckedInVersion = 0 " + "AND dc:title LIKE '" + docTitle.replace("'", "\\'") + "%'", this.filter);
            this.count = rs.size();
        }
    }

    private static class UnrestrictedGetParentsListRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel baseDoc;
        private DocumentModelList parentDocList;
        private Filter filter = null;
        private boolean immediateOnly;
        private boolean thisIncluded;

        public DocumentModelList getParentList() {
            return this.parentDocList;
        }

        protected UnrestrictedGetParentsListRunner(CoreSession session, DocumentModel document, Filter filter, boolean immediateOnly, boolean thisIncluded) {
            super(session);
            this.baseDoc = document;
            this.filter = filter;
            this.parentDocList = new DocumentModelListImpl();
            this.immediateOnly = immediateOnly;
            this.thisIncluded = thisIncluded;
        }

        public void run() throws ClientException {
            DocumentRef[] parentsRefList;
            if (this.thisIncluded && this.baseDoc.isFolder()) {
                if (null != this.filter) {
                    if (this.filter.accept(this.baseDoc)) {
                        this.parentDocList.add((Object)this.baseDoc);
                    }
                } else {
                    this.parentDocList.add((Object)this.baseDoc);
                }
            }
            if (null != (parentsRefList = this.session.getParentDocumentRefs(this.baseDoc.getRef())) && parentsRefList.length > 0) {
                for (DocumentRef parentsRef : parentsRefList) {
                    DocumentModel parent = this.session.getDocument(parentsRef);
                    if (null != this.filter) {
                        if (this.filter.accept(parent)) {
                            this.parentDocList.add((Object)parent);
                        }
                    } else {
                        this.parentDocList.add((Object)parent);
                    }
                    if (this.immediateOnly && this.parentDocList.size() == 1) break;
                }
            }
        }
    }

    private static class GetParentPropertiesRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel doc;
        private Filter filter;
        private boolean included;
        private boolean runInUnrestrictedMode;
        private List<String> lstxpath;
        private Map<String, Property> mapPpties;

        public GetParentPropertiesRunner(CoreSession session, DocumentModel document, List<String> lstXpaths, Filter filter, boolean runInUnrestrictedMode, boolean included) {
            super(session);
            this.doc = document;
            this.filter = filter;
            this.lstxpath = lstXpaths;
            this.included = included;
            this.runInUnrestrictedMode = runInUnrestrictedMode;
        }

        public Map<String, Property> getProperties() {
            return this.mapPpties;
        }

        public void run() throws ClientException {
            DocumentModelList lstParent = ToutaticeDocumentHelper.getParentList(this.session, this.doc, this.filter, this.runInUnrestrictedMode, true, this.included);
            DocumentModel parent = null;
            if (lstParent != null && !lstParent.isEmpty()) {
                parent = (DocumentModel)lstParent.get(0);
            }
            if (parent != null) {
                this.mapPpties = new HashMap<String, Property>(this.lstxpath.size());
                for (String xpath : this.lstxpath) {
                    this.mapPpties.put(xpath, parent.getProperty(xpath));
                }
            }
        }
    }

    private static class UnrestrictedGetProxyVersionLabelRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel proxy;
        private String versionLabel;

        public UnrestrictedGetProxyVersionLabelRunner(CoreSession session, DocumentModel proxy) {
            super(session);
            this.proxy = proxy;
            this.versionLabel = null;
        }

        public void run() throws ClientException {
            String srcDocID = this.proxy.getSourceId();
            if (srcDocID == null) {
                DocumentModel sourceDocument = this.session.getSourceDocument(this.proxy.getRef());
                srcDocID = sourceDocument.getId();
            }
            DocumentModel srcDoc = this.session.getDocument((DocumentRef)new IdRef(srcDocID));
            this.versionLabel = srcDoc.getVersionLabel();
        }

        public String getVersionLabel() {
            return this.versionLabel;
        }
    }

    private static class UnrestrictedGetProxyRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel document;
        private DocumentModelList proxies = null;
        private ToutaticeGlobalConst.CST_TOUTATICE_PROXY_LOOKUP_SCOPE scope;

        public UnrestrictedGetProxyRunner(CoreSession session, DocumentModel document) {
            this(session, document, ToutaticeGlobalConst.CST_TOUTATICE_PROXY_LOOKUP_SCOPE.LOCAL);
        }

        public UnrestrictedGetProxyRunner(CoreSession session, DocumentModel document, ToutaticeGlobalConst.CST_TOUTATICE_PROXY_LOOKUP_SCOPE scope) {
            super(session);
            this.document = document;
            this.scope = scope;
        }

        public DocumentModel getProxy() throws ClientException {
            return null != this.proxies && 0 < this.proxies.size() ? (DocumentModel)this.proxies.get(0) : null;
        }

        public DocumentModelList getProxies() throws ClientException {
            return null != this.proxies && 0 < this.proxies.size() ? this.proxies : null;
        }

        public void run() throws ClientException {
            this.proxies = null == this.scope || ToutaticeGlobalConst.CST_TOUTATICE_PROXY_LOOKUP_SCOPE.GLOBAL.equals((Object)this.scope) ? this.session.getProxies(this.document.getRef(), null) : this.session.getProxies(this.document.getRef(), this.document.getParentRef());
        }
    }

    public static class DocumentVersionComparator
    implements Comparator<DocumentModel> {
        private DocumentVersionComparator() {
        }

        @Override
        public int compare(DocumentModel arg0, DocumentModel arg1) {
            int result = 0;
            if (null != arg0 && null != arg1) {
                result = DocumentVersionComparator.isNewer(arg0, arg1) ? 1 : -1;
            }
            return result;
        }

        public static boolean isNewer(DocumentModel ref, DocumentModel comp) {
            boolean isNewer = false;
            try {
                GregorianCalendar ref_modified = (GregorianCalendar)ref.getPropertyValue("dc:modified");
                GregorianCalendar comp_modified = (GregorianCalendar)comp.getPropertyValue("dc:modified");
                isNewer = comp_modified.after(ref_modified);
            }
            catch (ClientException e) {
                log.debug((Object)"Failed to determine wich document is the latest modified");
            }
            return isNewer;
        }

        public static boolean isBigger(String v0, String v1) {
            String[] sV0 = v0.split("\\.");
            String[] sV1 = v1.split("\\.");
            int majorV0 = Integer.parseInt(sV0[0]);
            int minorV0 = Integer.parseInt(sV0[1]);
            int majorV1 = Integer.parseInt(sV1[0]);
            int minorV1 = Integer.parseInt(sV1[1]);
            return majorV0 > majorV1 || majorV0 == majorV1 && minorV0 > minorV1;
        }
    }

    public static class SilentRemoveRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentRef docRef;

        public SilentRemoveRunner(CoreSession session, DocumentRef docRef) {
            super(session);
            this.docRef = docRef;
        }

        public void run() throws ClientException {
            this.session.removeDocument(this.docRef);
        }
    }

    public static class SilentSave
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;

        protected SilentSave(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            this.session.saveDocument(this.document);
        }
    }

    public static class GetUnrestrictedProperty
    extends UnrestrictedSessionRunner {
        private String docId;
        private String xpathProperty;
        private boolean getValue;
        private Serializable property;

        protected GetUnrestrictedProperty(CoreSession session, String docId, String xpathProperty, boolean getValue) {
            super(session);
            this.docId = docId;
            this.xpathProperty = xpathProperty;
            this.getValue = getValue;
        }

        public void run() throws ClientException {
            DocumentModel document = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            this.property = this.getValue ? document.getPropertyValue(this.xpathProperty) : document.getProperty(this.xpathProperty);
        }

        public Serializable getProperty() {
            return this.property;
        }
    }

    public static class GetUnresrictedParent
    extends UnrestrictedSessionRunner {
        private DocumentModel document;
        private DocumentModel parent;

        protected GetUnresrictedParent(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            this.parent = this.session.getParentDocument(this.document.getRef());
        }

        public DocumentModel get() {
            return this.parent;
        }
    }

    public static class GetUnrestrictedDocument
    extends UnrestrictedSessionRunner {
        private String id;
        private DocumentModel document;

        public DocumentModel getDocument() {
            return this.document;
        }

        public GetUnrestrictedDocument(CoreSession session, String id) {
            super(session);
            this.id = id;
        }

        public void run() throws ClientException {
            if (StringUtils.isNotBlank((String)this.id)) {
                Object ref = null;
                ref = !StringUtils.contains((String)this.id, (String)"/") ? new IdRef(this.id) : new PathRef(this.id);
                this.document = this.session.getDocument((DocumentRef)ref);
            }
        }
    }
}

