/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.document;

import fr.toutatice.ecm.platform.core.constants.PortalConstants;
import fr.toutatice.ecm.platform.core.constants.ToutaticeGlobalConst;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeImageCollectionHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import fr.toutatice.ecm.platform.services.permalink.PermaLinkService;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActions;
import fr.toutatice.ecm.platform.web.fragments.PageBean;
import fr.toutatice.ecm.platform.web.workflows.ToutaticeDocumentRoutingActionsBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.ListDiff;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.picture.web.PictureBookManager;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActionsBean;
import org.nuxeo.runtime.api.Framework;

@Name(value="documentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeDocumentActionsBean
extends DocumentActionsBean
implements ToutaticeDocumentActions,
Serializable {
    private static final long serialVersionUID = -2085111938280655851L;
    private static final Log log = LogFactory.getLog(ToutaticeDocumentActionsBean.class);
    private InputStream uploadedImage;
    private String uploadedImageName;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected PageBean pageBean;
    @In(create=true)
    protected transient PictureBookManager pictureBookManager;
    protected transient PermaLinkService permaLinkService;
    protected transient ToutaticeDocumentRoutingActionsBean routingActionBean;
    @RequestParameter(value="type")
    protected String typeName;
    @RequestParameter(value="params")
    protected String reqParams;
    protected boolean live = true;
    String newSwitchValue;
    String newKeyword;
    String source;
    Map<String, Boolean> mapSwitchState = null;
    protected static final String CST_DEFAULT_PUBLICATON_AREA_TITLE = "inconnu";
    protected static final String CST_DEFAULT_PUBLICATON_AREA_PATH = "/";
    protected static final String CST_DEFAULT_UNKNOWN_VERSION_LABEL = "Version ind\u00e9termin\u00e9e";

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    @Create
    public void initialize() throws Exception {
        log.debug((Object)"Initializing...");
    }

    @Destroy
    @Remove
    @PermitAll
    public void destroy() {
        log.debug((Object)"Removing SEAM action listener...");
    }

    @PrePassivate
    public void saveState() {
        log.debug((Object)"PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.debug((Object)"PostActivate");
    }

    protected ToutaticeDocumentRoutingActionsBean getDocumentRoutingActionBean() {
        return (ToutaticeDocumentRoutingActionsBean)((Object)SeamComponentCallHelper.getSeamComponentByName((String)"routingActions"));
    }

    public boolean getEveryThingRight() throws ClientException {
        return this.documentManager.hasPermission(this.navigationContext.getCurrentDocument().getRef(), "Everything");
    }

    public boolean checkPermission(DocumentModel document, String permission) throws ClientException {
        return this.documentManager.hasPermission(document.getRef(), permission);
    }

    public DocumentModel getParent(DocumentModel document, boolean unrestricted) {
        DocumentModel parent = null;
        DocumentModelList parentList = ToutaticeDocumentHelper.getParentList((CoreSession)this.documentManager, (DocumentModel)document, null, (boolean)unrestricted, (boolean)true);
        if (CollectionUtils.isNotEmpty((Collection)parentList)) {
            parent = (DocumentModel)parentList.get(0);
        }
        return parent;
    }

    public boolean isRemoteProxy() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return currentDocument.isProxy() && !StringUtils.endsWith((String)currentDocument.getName(), (String)".proxy");
    }

    public boolean isRemoteProxy(DocumentModel currentDocument) {
        return currentDocument.hasFacet("isRemoteProxy");
    }

    public String saveDocument() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        this.updateDocWithMapSwitch(changeableDocument);
        return super.saveDocument(changeableDocument);
    }

    public String saveDocument(String viewId) throws ClientException {
        this.saveDocument();
        String msgSuccessKey = this.isInPublishSpace(this.getCurrentDocument()) ? PortalConstants.Notifications.SUCCESS_MESSAGE_CREATE.name() : PortalConstants.Notifications.SUCCESS_MESSAGE_CREATE_IN_WS.name();
        this.pageBean.setNotificationKey(msgSuccessKey);
        this.live = true;
        return viewId;
    }

    @Override
    public String updateDocument(DocumentModel doc) throws ClientException {
        return super.updateDocument(doc);
    }

    public String createMajorDocument() throws ClientException {
        String viewId = this.saveDocument();
        this.updateNUpgradeCurrentDocument("MAJOR");
        return viewId;
    }

    public String createMajorDocument(String viewId) throws ClientException {
        this.createMajorDocument();
        return viewId;
    }

    public String saveNSetOnLineDocument() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        this.updateDocWithMapSwitch(changeableDocument);
        String view = super.saveDocument(changeableDocument);
        this.pageBean.setNotificationKey(PortalConstants.Notifications.SUCCESS_MESSAGE_CREATE.name());
        DocumentModel newDocument = this.navigationContext.getCurrentDocument();
        this.setDocumentOnline(newDocument);
        return view;
    }

    public String saveNSetOnLineDocument(String viewId) throws ClientException {
        this.saveNSetOnLineDocument();
        return viewId;
    }

    public String constraintImage(Integer imageIndex, String resConstraint) throws ToutaticeException {
        if (StringUtils.isBlank((String)resConstraint) || StringUtils.split((String)resConstraint, (char)'x').length < 2) {
            throw new ClientException("resConstraint must be provided");
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        OperationContext ctx = new OperationContext(this.documentManager);
        String imageXpath = "ttc:images/" + imageIndex;
        String[] widthHeigth = StringUtils.split((String)resConstraint, (char)'x');
        Integer width = new Integer(widthHeigth[0]);
        Integer height = new Integer(widthHeigth[1]);
        ctx.setInput((Object)currentDocument);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("xpath_img_in", imageXpath);
        parameters.put("xpath_img_out", imageXpath);
        parameters.put("img_width", width);
        parameters.put("img_heidth", height);
        parameters.put("enlarge", true);
        ToutaticeOperationHelper.callOperation((OperationContext)ctx, (String)"ImageResize.Operation", parameters);
        return this.updateCurrentDocument("osivia_edit_attachments");
    }

    public String deleteImage(Integer imageIndex) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        List files = (List)((Object)currentDocument.getPropertyValue("ttc:images"));
        Object file = CollectionUtils.get((Object)files, (int)imageIndex);
        ToutaticeImageCollectionHelper.instance().remove(files, file);
        currentDocument.setPropertyValue("ttc:images", (Serializable)((Object)files));
        return this.updateCurrentDocument("osivia_edit_attachments");
    }

    public String uploadImage() throws ClientException {
        return this.uploadImage(null);
    }

    public String uploadImage(Integer imageIndex) throws ClientException {
        if (this.uploadedImage == null || this.uploadedImageName == null) {
            return "";
        }
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        HashMap<String, String> props = new HashMap<String, String>();
        this.uploadedImageName = FileUtils.getCleanFileName((String)this.uploadedImageName);
        props.put("filename", this.uploadedImageName);
        props.put("file", (String)FileUtils.createSerializableBlob((InputStream)this.uploadedImage, (String)this.uploadedImageName, null));
        ListDiff listDiff = new ListDiff();
        if (imageIndex != null) {
            List filesList = (List)doc.getProperty("files", "files");
            int lastIndex = filesList == null ? 0 : filesList.size();
            int fileIndex = imageIndex > lastIndex ? lastIndex : imageIndex;
            listDiff.modify(fileIndex, props);
        } else {
            listDiff.add(props);
        }
        doc.setProperty("files", "files", (Object)listDiff);
        return "osivia_edit_attachments";
    }

    public String createNSetOnLinePictureBook() throws Exception {
        String view = "";
        if (null != this.pictureBookManager) {
            view = this.pictureBookManager.createPictureBook();
            DocumentModel newDocument = this.navigationContext.getCurrentDocument();
            this.setDocumentOnline(newDocument);
        } else {
            log.error((Object)"Failed to get the picture book manager from seam context");
        }
        return view;
    }

    public String createPictureBook(String viewId) throws Exception {
        if (null != this.pictureBookManager) {
            this.pictureBookManager.createPictureBook();
            this.pageBean.setNotificationKey(PortalConstants.Notifications.SUCCESS_MESSAGE_CREATE.name());
            this.live = true;
        } else {
            log.error((Object)"Failed to get the picture book manager from seam context");
        }
        return viewId;
    }

    public String createNSetOnLinePictureBook(String viewId) throws Exception {
        if (null != this.pictureBookManager) {
            this.pictureBookManager.createPictureBook();
            DocumentModel newDocument = this.navigationContext.getCurrentDocument();
            this.setDocumentOnline(newDocument);
        } else {
            log.error((Object)"Failed to get the picture book manager from seam context");
        }
        return viewId;
    }

    public String updateCurrentDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.updateDocWithMapSwitch(currentDocument);
        String viewId = super.updateDocument(currentDocument);
        return viewId;
    }

    public String updateCurrentDocument(String viewId) throws ClientException {
        this.updateCurrentDocument();
        this.pageBean.setNotificationKey(PortalConstants.Notifications.SUCCESS_MESSAGE_MODIFY.name());
        this.live = true;
        return viewId;
    }

    @Override
    public String updateNUpgradeCurrentDocument(String version) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        VersioningOption vo = null;
        if ("MAJOR".equalsIgnoreCase(version)) {
            vo = VersioningOption.MAJOR;
        } else if ("MINOR".equalsIgnoreCase(version)) {
            vo = VersioningOption.MINOR;
        }
        currentDocument.putContextData("VersioningOption", (Serializable)vo);
        return this.updateCurrentDocument();
    }

    public String updateNUpgradeCurrentDocument(String version, String viewId) throws ClientException {
        this.updateNUpgradeCurrentDocument(version);
        this.pageBean.setNotificationKey(PortalConstants.Notifications.SUCCESS_MESSAGE_MODIFY.name());
        this.live = true;
        return viewId;
    }

    public String updateNSetOnLineCurrentDocument() throws ClientException {
        String view = null;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.updateDocWithMapSwitch(currentDocument);
        view = super.updateDocument(currentDocument);
        this.pageBean.setNotificationKey(PortalConstants.Notifications.SUCCESS_MESSAGE_MODIFY.name());
        currentDocument = this.navigationContext.getCurrentDocument();
        this.setDocumentOnline(currentDocument);
        return view;
    }

    public String updateNSetOnLineCurrentDocument(String viewId) throws ClientException {
        this.updateNSetOnLineCurrentDocument();
        return viewId;
    }

    @Override
    public void updateDocWithMapSwitch(DocumentModel document) throws PropertyException, ClientException {
        if (null == this.mapSwitchState) {
            return;
        }
        for (String key : this.mapSwitchState.keySet()) {
            if (!this.mapSwitchState.get(key).booleanValue()) continue;
            document.setPropertyValue(key, null);
        }
    }

    public String getNewKeyword() {
        return this.newKeyword;
    }

    public void setNewKeyword(String newKeyword) {
        this.newKeyword = newKeyword;
    }

    public String getNewSwitchValue() {
        return this.newSwitchValue;
    }

    public void setNewSwitchValue(String newSwitchValue) {
        this.newSwitchValue = newSwitchValue;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    private String extractExtension(String fileName) throws ClientException {
        String[] parts = fileName.split("\\.");
        if (parts.length > 1) {
            return parts[parts.length - 1];
        }
        return "none";
    }

    public boolean isFileMp3Playable(String fileName) throws ClientException {
        return this.extractExtension(fileName).equalsIgnoreCase("mp3");
    }

    public boolean isFileImage(String fileName) throws ClientException {
        return this.extractExtension(fileName).equalsIgnoreCase("gif") || this.extractExtension(fileName).equalsIgnoreCase("jpeg") || this.extractExtension(fileName).equalsIgnoreCase("jpg") || this.extractExtension(fileName).equalsIgnoreCase("png");
    }

    @Factory(value="currentEditedDocument", scope=ScopeType.EVENT)
    public DocumentModel factoryCurrentEditedDocument() {
        return this.navigationContext.getCurrentDocument();
    }

    public DocumentModel getCurrentDocument() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getChangeableDocument();
        if (!this.isNewlyCreatedChangeableDocument(currentDoc) && (currentDoc = this.navigationContext.getCurrentDocument()) == null) {
            log.debug((Object)"current document cannot be initialized");
        }
        return currentDoc;
    }

    private boolean isNewlyCreatedChangeableDocument(DocumentModel changeableDocument) throws ClientException {
        return changeableDocument != null && changeableDocument.getId() == null && changeableDocument.getPath() == null && changeableDocument.getTitle() == null;
    }

    public boolean isOnlineDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.isOnlineDocument(currentDocument);
    }

    public boolean isInPublishSpace(DocumentModel document) {
        return ToutaticeDocumentHelper.isInPublishSpace((CoreSession)this.documentManager, (DocumentModel)document);
    }

    public boolean isOnlineDocument(DocumentModel document) throws ClientException {
        boolean res = false;
        try {
            if (ToutaticeDocumentHelper.isDocStillExists((CoreSession)this.documentManager, (DocumentModel)document)) {
                res = this.hasProxy(document);
            }
        }
        catch (DocumentSecurityException se) {
            log.warn((Object)se.getMessage());
        }
        return res;
    }

    @Override
    public boolean hasProxy(DocumentModel document) throws ClientException {
        return null != this.getProxy(document);
    }

    public boolean isOnlineWithSameVersion() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.isOnlineWithSameVersion(currentDocument);
    }

    @Override
    public String getProxyVersion(DocumentModel document) throws ClientException {
        String proxyVersion = ToutaticeDocumentHelper.getProxyVersion((CoreSession)this.documentManager, (DocumentModel)document);
        return StringUtils.isNotBlank((String)proxyVersion) ? proxyVersion : CST_DEFAULT_UNKNOWN_VERSION_LABEL;
    }

    @Override
    public DocumentModel getProxy(DocumentModel document) throws ClientException {
        return ToutaticeDocumentHelper.getProxy((CoreSession)this.documentManager, (DocumentModel)document, (String)"Read");
    }

    public boolean isSeeOnlineDocumentVersionActionAuthorized() {
        boolean status = false;
        DocumentModel currentDoc = null;
        try {
            currentDoc = this.navigationContext.getCurrentDocument();
            String proxyVersionLabel = this.getProxyVersion(currentDoc);
            if (!CST_DEFAULT_UNKNOWN_VERSION_LABEL.equals(proxyVersionLabel)) {
                status = !currentDoc.getVersionLabel().equals(proxyVersionLabel);
            }
        }
        catch (Exception e) {
            String docName = null != currentDoc ? currentDoc.getName() : "unknown";
            log.debug((Object)("Failed to check the online status of the document '" + docName + "', error: " + e.getMessage()));
        }
        return status;
    }

    public boolean isSeeLiveDocumentVersionActionAuthorized() {
        boolean status = false;
        DocumentModel currentDoc = null;
        try {
            boolean isDeleted;
            currentDoc = this.navigationContext.getCurrentDocument();
            DocumentModel sourceVersionDoc = this.documentManager.getSourceDocument(currentDoc.getRef());
            DocumentModel workingCopy = this.documentManager.getWorkingCopy(sourceVersionDoc.getRef());
            boolean bl = isDeleted = workingCopy == null || workingCopy != null && "deleted".equals(workingCopy.getCurrentLifeCycleState());
            if (!isDeleted && !sourceVersionDoc.getId().equals(currentDoc.getId()) && this.documentManager.hasPermission(sourceVersionDoc.getRef(), "Read")) {
                status = true;
            }
        }
        catch (Exception e) {
            String docName = null != currentDoc ? currentDoc.getName() : "unknown";
            log.debug((Object)("Failed to check the status to see the live version of the document '" + docName + "', error: " + e.getMessage()));
        }
        return status;
    }

    public String viewLiveVersion() throws ClientException {
        String output = "";
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        try {
            DocumentModel liveDoc;
            DocumentModel sourceVersionDoc = this.documentManager.getSourceDocument(currentDoc.getRef());
            if (null != sourceVersionDoc && null != (liveDoc = this.documentManager.getSourceDocument(sourceVersionDoc.getRef()))) {
                output = this.navigationContext.navigateToDocument(liveDoc);
            }
        }
        catch (ClientException e) {
            log.info((Object)("The proxy document (' " + currentDoc.getName() + "') has lost its reference to the version document"));
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.toutatice.viewlive.reference.lost"), new Object[0]);
        }
        return output;
    }

    public String viewOnlineVersion() throws ClientException {
        return this.viewOnlineVersion(this.navigationContext.getCurrentDocument());
    }

    public String viewOnlineVersion(DocumentModel document) throws ClientException {
        String output = "";
        try {
            DocumentModel proxy = this.getProxy(document);
            if (null != proxy) {
                String srcDocId = proxy.getSourceId();
                DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)new IdRef(srcDocId));
                output = this.navigationContext.navigateToDocument(document, ToutaticeDocumentHelper.getVersionModel((DocumentModel)srcDoc));
            }
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
        return output;
    }

    protected void setDocumentOnline(DocumentModel document) {
        try {
            String proxyVersionLabel = this.getProxyVersion(document);
            if (!document.getVersionLabel().equals(proxyVersionLabel)) {
                if (this.documentManager.hasPermission(document.getRef(), "validationWorkflow_validation")) {
                    ToutaticeOperationHelper.runOperationChain((CoreSession)this.documentManager, (String)"setOnLine", (Object)document);
                    this.pageBean.setNotificationKey(PortalConstants.Notifications.SUCCESS_MESSAGE_PUBLISH.name());
                    this.live = false;
                } else {
                    this.getDocumentRoutingActionBean().startOnlineWorkflow();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to set online the document: '" + document.getName() + "', error: " + e.getMessage()));
        }
    }

    public void publishDocumentSelection() {
        List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (currentDocumentSelection.isEmpty()) {
            return;
        }
        for (DocumentModel selectedDocument : currentDocumentSelection) {
            this.setDocumentOnline(selectedDocument);
        }
        this.documentsListsManager.resetWorkingList("CURRENT_SELECTION");
        DocumentModel currentFolder = this.navigationContext.getCurrentDocument();
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentFolder});
    }

    public void unPublishDocumentSelection() throws ClientException {
        DocumentModel currentFolder = this.navigationContext.getCurrentDocument();
        List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (currentDocumentSelection.isEmpty()) {
            return;
        }
        try {
            ToutaticeOperationHelper.runOperationChain((CoreSession)this.documentManager, (String)"setOffLineSelection", (Object)new DocumentModelListImpl(currentDocumentSelection));
        }
        catch (Exception e) {
            log.error((Object)("Failed to set offline the selection from the document: '" + currentFolder.getTitle() + "', error: " + e.getMessage()));
        }
        this.documentsListsManager.resetWorkingList("CURRENT_SELECTION");
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentFolder});
    }

    public String formatMessages(String message, Object ... params) throws ClientException {
        String formattedString = "";
        if (null != params && params.length > 0) {
            FacesMessage faceMsg = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)((String)this.resourcesAccessor.getMessages().get(message)), (Object[])params);
            formattedString = faceMsg.getDetail();
        }
        return formattedString;
    }

    @Override
    public boolean belongToPublishSpace() {
        return !ToutaticeGlobalConst.NULL_DOCUMENT_MODEL.getType().equals(((ToutaticeNavigationContext)this.navigationContext).getCurrentPublicationArea().getType());
    }

    public String getPublicationAreaNameOfCurrentDocument() {
        return this.getPublicationAreaName(this.navigationContext.getCurrentDocument());
    }

    @Override
    public boolean belongToWorkSpace() {
        return !ToutaticeGlobalConst.NULL_DOCUMENT_MODEL.getType().equals(((ToutaticeNavigationContext)this.navigationContext).getCurrentWorkspaceArea().getType());
    }

    public String getSpacePath() {
        return this.getSpacePath(this.navigationContext.getCurrentDocument());
    }

    @Override
    public List<String> getDocumentPathSegments(DocumentModel document, DocumentModel referenceDoc) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (null != referenceDoc && document.getId().equals(referenceDoc.getId()) || "Domain".equals(document.getType())) {
                return list;
            }
            list.add(document.getTitle());
            DocumentModel parent = this.documentManager.getParentDocument(document.getRef());
            list.addAll(this.getDocumentPathSegments(parent, referenceDoc));
        }
        catch (ClientException e) {
            log.error((Object)("Failed to get the path segments of document '" + document.getName() + "', error: " + e.getMessage()));
        }
        return list;
    }

    private String getSpacePath(DocumentModel document) {
        String path = CST_DEFAULT_PUBLICATON_AREA_PATH;
        DocumentModel space = ((ToutaticeNavigationContext)this.navigationContext).getPublicationArea(document);
        if (ToutaticeGlobalConst.NULL_DOCUMENT_MODEL.getType().equals(space.getType())) {
            space = this.navigationContext.getCurrentWorkspace();
        }
        if (null != space) {
            path = space.getPathAsString();
        }
        return path;
    }

    protected String getPublicationAreaName(DocumentModel document) {
        String name = CST_DEFAULT_PUBLICATON_AREA_TITLE;
        DocumentModel area = ((ToutaticeNavigationContext)this.navigationContext).getPublicationArea(document);
        if (!ToutaticeGlobalConst.NULL_DOCUMENT_MODEL.getType().equals(area.getType())) {
            try {
                name = area.getTitle();
            }
            catch (ClientException e) {
                log.debug((Object)("Failed to get the publication area name, error: " + e.getMessage()));
            }
        }
        return name;
    }

    private boolean isOnlineWithSameVersion(DocumentModel document) {
        boolean status = false;
        try {
            String onlineDocVersion = this.getProxyVersion(document);
            if (document.getVersionLabel().equals(onlineDocVersion)) {
                status = true;
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to execute 'isOnlineWithSameVersion', error: " + e.getMessage()));
        }
        return status;
    }

    public DocumentModel getOrCreateChangeableDocument() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        if (changeableDocument == null && this.typeName != null) {
            DocumentModel container = this.navigationContext.getCurrentDocument();
            Type cType = this.typeManager.getType(container.getType());
            Map allowedSubTypes = cType.getAllowedSubTypes();
            if (!allowedSubTypes.containsKey(this.typeName)) {
                return null;
            }
            this.createDocument(this.typeName);
            changeableDocument = this.navigationContext.getChangeableDocument();
            if (this.reqParams != null && !"null".equalsIgnoreCase(this.reqParams)) {
                try {
                    Base64 b64 = new Base64();
                    byte[] tabByte = b64.decode(this.reqParams.getBytes());
                    ByteArrayInputStream io = new ByteArrayInputStream(tabByte);
                    ObjectInputStream ois = new ObjectInputStream(io);
                    Object o = ois.readObject();
                    Map params = new HashMap();
                    if (o instanceof Map) {
                        params = (Map)o;
                    }
                    for (String xpath : params.keySet()) {
                        changeableDocument.setPropertyValue(xpath, (Serializable)params.get(xpath));
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ClientException(cnfe.getMessage());
                }
                catch (IOException ioe) {
                    throw new ClientException(ioe.getMessage());
                }
            }
        }
        return changeableDocument;
    }

    public boolean areWidgetFieldsAllEmpty(DocumentModel doc, FieldDefinition[] fields) {
        boolean status = true;
        for (FieldDefinition field : fields) {
            try {
                Object fieldValue;
                String xpath = field.getPropertyName();
                if (xpath.matches(".*/\\d*")) {
                    String[] xpathElts = xpath.split(CST_DEFAULT_PUBLICATON_AREA_PATH);
                    xpath = xpathElts[0];
                    int index = Integer.parseInt(xpathElts[1]);
                    fieldValue = doc.getPropertyValue(xpath);
                    String[] fieldValueList = (String[])fieldValue;
                    fieldValue = fieldValueList.length >= index ? fieldValueList[index] : null;
                } else {
                    fieldValue = doc.getPropertyValue(xpath);
                }
                if (this.isFieldValueEmpty((Serializable)fieldValue)) continue;
                status = false;
                break;
            }
            catch (Exception e) {
                try {
                    log.debug((Object)("Failed to analyse the document fields (document name: '" + doc.getTitle() + "'), error:" + e.getMessage()));
                }
                catch (ClientException clientException) {
                    // empty catch block
                }
            }
        }
        return status;
    }

    private boolean isFieldValueEmpty(Serializable fieldValue) {
        boolean status = true;
        if (null != fieldValue) {
            if (fieldValue instanceof String) {
                String fieldValueStg = (String)((Object)fieldValue);
                if (StringUtils.isNotBlank((String)fieldValueStg)) {
                    status = false;
                }
            } else if (fieldValue instanceof String[]) {
                String[] fieldValuesList = (String[])fieldValue;
                if (fieldValuesList.length > 0) {
                    for (String item : fieldValuesList) {
                        if (this.isFieldValueEmpty((Serializable)((Object)item))) continue;
                        status = false;
                        break;
                    }
                }
            } else {
                status = false;
            }
        }
        return status;
    }

    public Map<String, Boolean> getMapSwitchState() {
        if (this.mapSwitchState == null) {
            this.mapSwitchState = new HashMap<String, Boolean>();
        }
        return this.mapSwitchState;
    }

    public void setMapSwitchState(Map<String, Boolean> mapSwitchState) {
        this.mapSwitchState = mapSwitchState;
    }

    @Observer(value={"documentSelectionChanged"})
    public void resetChgDocument() {
        this.navigationContext.setChangeableDocument(null);
    }

    @Observer(value={"documentSelectionChanged", "changeableDocumentCreated"})
    public Map<String, Boolean> razMapSwitchState() {
        if (null == this.mapSwitchState) {
            this.mapSwitchState = new HashMap<String, Boolean>();
        } else {
            this.mapSwitchState.clear();
        }
        return this.mapSwitchState;
    }

    @Observer(value={"changeableDocumentCreated"})
    public void initShowInMenu() throws ClientException {
        DocumentModel newDocument = this.navigationContext.getChangeableDocument();
        if (newDocument.hasFacet("SpaceNavigationItem") || "Folder".equals(newDocument.getType()) || "OrderedFolder".equals(newDocument.getType())) {
            newDocument.setPropertyValue("ttc:showInMenu", (Serializable)Boolean.valueOf(true));
            if ("PortalSite".equals(newDocument.getType())) {
                newDocument.setPropertyValue("ttc:contextualizeInternalContents", (Serializable)Boolean.valueOf(true));
            }
        }
    }

    public boolean showShowInMenu() throws ClientException {
        boolean res = false;
        DocumentModel newDocument = this.navigationContext.getChangeableDocument();
        if (newDocument == null) {
            newDocument = this.navigationContext.getCurrentDocument();
        }
        if (newDocument.hasFacet("SpaceContent") || "Folder".equals(newDocument.getType()) || "OrderedFolder".equals(newDocument.getType())) {
            res = true;
        }
        return res;
    }

    public boolean initSwitchState(String param) throws PropertyException, ClientException {
        DocumentModel currentDoc;
        if (null == this.mapSwitchState) {
            this.mapSwitchState = new HashMap<String, Boolean>();
        }
        if (this.mapSwitchState.get(param) == null && (currentDoc = this.getCurrentDocument()) != null && param != null) {
            Serializable value = currentDoc.getPropertyValue(param);
            if (value == null || value instanceof String[] && ((String[])value).length == 0) {
                this.mapSwitchState.put(param, true);
            } else {
                this.mapSwitchState.put(param, false);
            }
        }
        return this.mapSwitchState.get(param);
    }

    public String navigateToView(String viewId) throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return this.navigationContext.navigateToDocument(doc, viewId);
    }

    public String addDocumentKeyword() throws ClientException {
        if (this.newKeyword == null || "".equals(this.newKeyword)) {
            return null;
        }
        DocumentModel currentDoc = this.getCurrentDocument();
        if (currentDoc != null) {
            String[] s;
            List<Object> subjects;
            Object subjectsObj = currentDoc.getProperty("toutatice", "keywords");
            if (subjectsObj != null) {
                if (subjectsObj instanceof List) {
                    subjects = (List)subjectsObj;
                } else {
                    String[] subjectsArray = (String[])subjectsObj;
                    subjects = Arrays.asList(subjectsArray);
                    subjects = new ArrayList(subjects);
                }
            } else {
                subjects = new ArrayList();
            }
            if (this.newKeyword.contains("  ")) {
                this.newKeyword = this.newKeyword.replaceAll("  ", " ");
            }
            if (this.newKeyword.contains(", ") || this.newKeyword.contains(" ,")) {
                this.newKeyword = this.newKeyword.replaceAll(", ", ",");
                this.newKeyword = this.newKeyword.replaceAll(" ,", ",");
            }
            for (String element : s = this.newKeyword.split(",")) {
                subjects.add(element);
            }
            this.newKeyword = "";
            currentDoc.setProperty("toutatice", "keywords", subjects);
        }
        return null;
    }

    public String removeDocumentKeyword() throws ClientException {
        DocumentModel currentDoc = this.getCurrentDocument();
        if (currentDoc != null) {
            List<String> subjects;
            Object subjectsObj = currentDoc.getProperty("toutatice", "keywords");
            if (subjectsObj instanceof List) {
                subjects = (List<String>)subjectsObj;
            } else {
                String[] subjectsArray = (String[])subjectsObj;
                subjects = Arrays.asList(subjectsArray);
                subjects = new ArrayList<String>(subjects);
            }
            FacesContext context = FacesContext.getCurrentInstance();
            String subject = (String)context.getExternalContext().getRequestParameterMap().get("subject");
            subjects.remove(subject);
            currentDoc.setProperty("toutatice", "keywords", subjects);
        }
        return null;
    }

    public String removeDocumentWebId() throws ClientException {
        DocumentModel currentDoc = this.getCurrentDocument();
        if (currentDoc != null) {
            currentDoc.setProperty("toutatice", "webid", (Object)"");
        }
        return null;
    }

    public PermaLinkService getPermaLinkService() throws ClientException {
        try {
            if (this.permaLinkService == null) {
                this.permaLinkService = (PermaLinkService)Framework.getService(PermaLinkService.class);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the publication service, exception message: " + e.getMessage()));
            throw new ClientException("Failed to get the publication service, exception message: " + e.getMessage());
        }
        return this.permaLinkService;
    }

    @Override
    public String getDocumentPermalink() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getDocumentPermalink(currentDoc);
    }

    @Override
    public String getPermalink(String codec) {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getPermaLinkService().getPermalink(currentDoc, codec);
    }

    public String getPermalink(DocumentModel doc, String codec) {
        return this.getPermaLinkService().getPermalink(doc, codec);
    }

    public String getDocumentPermalink(DocumentModel doc) throws ClientException {
        return this.getPermaLinkService().getPermalink(doc);
    }

    @Override
    public boolean hasChildrenWithType(String type) throws ClientException {
        DocumentModelList docLst = this.documentManager.getChildren(this.navigationContext.getCurrentDocument().getRef(), type);
        return docLst != null && !docLst.isEmpty();
    }

    public boolean hasView(String viewId) {
        return ToutaticeDocumentHelper.hasView((DocumentModel)this.navigationContext.getCurrentDocument(), (String)viewId);
    }

    public boolean isTypeCommentable() {
        SchemaManager service = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType documentType = service.getDocumentType(this.navigationContext.getCurrentDocument().getType());
        return documentType.hasFacet("Commentable");
    }
}

