/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.reporting.test.mode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestModeException;

public class ErrorTestMode {
    public static final String ERROR_TEST_MODE = "ottc.scan.error.test.mode";
    private static int GENERATE_USE_CASE_ERROR_INDICATOR = 0;
    private static List<Integer> generatedUCErrors = new ArrayList<Integer>(5);
    private static Map<Integer, Boolean> generatedUCErrorsInTry = new HashMap<Integer, Boolean>(1);

    private ErrorTestMode() {
    }

    public static void incrementUCErrorsIndicator() {
        ++GENERATE_USE_CASE_ERROR_INDICATOR;
    }

    public static void resetGeneratedUseCaseErrors() {
        if (ErrorTestMode.isActivated()) {
            GENERATE_USE_CASE_ERROR_INDICATOR = 0;
            generatedUCErrors = new ArrayList<Integer>(5);
            generatedUCErrorsInTry = new HashMap<Integer, Boolean>(1);
        }
    }

    public static boolean isActivated() {
        String mode = Framework.getProperty((String)ERROR_TEST_MODE, (String)"false");
        return BooleanUtils.isTrue((Boolean)Boolean.valueOf(mode));
    }

    public static boolean generateError(int uCError) throws ErrorTestModeException {
        boolean generate = false;
        if (ErrorTestMode.isActivated()) {
            boolean hasToGenerate;
            boolean bl = hasToGenerate = GENERATE_USE_CASE_ERROR_INDICATOR % 2 == 0;
            if (hasToGenerate && !generatedUCErrors.contains(uCError)) {
                generatedUCErrors.add(uCError);
                generate = true;
            }
        }
        return generate;
    }

    public static boolean generateErrorInTry(int uCError) throws ErrorTestModeException {
        boolean generate = false;
        if (ErrorTestMode.isActivated()) {
            boolean hasToGenerate;
            boolean bl = hasToGenerate = GENERATE_USE_CASE_ERROR_INDICATOR % 2 == 0;
            if (hasToGenerate) {
                if (!generatedUCErrorsInTry.keySet().contains(uCError)) {
                    generatedUCErrorsInTry.put(uCError, Boolean.TRUE);
                    generate = true;
                } else {
                    Boolean toGenerate = generatedUCErrorsInTry.get(uCError);
                    generate = BooleanUtils.isTrue((Boolean)toGenerate);
                    if (generate) {
                        generatedUCErrorsInTry.put(uCError, Boolean.FALSE);
                    }
                }
            }
        }
        return generate;
    }
}

