/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.portalviews.adapter.dates;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetsAdapterService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class WidgetsTTCDatesMergeListener
implements EventListener {
    public static final String DATE_TIME_FORMAT = "dd/MM/yyyy HH:mm";
    public static final String DEFAULT_TIME = "12:00";

    public void handleEvent(Event event) throws ClientException {
        String eventName;
        if (event.getContext() instanceof DocumentEventContext && ("documentCreated".equals(eventName = event.getName()) || "beforeDocumentModification".equals(eventName))) {
            EventContext ctx = event.getContext();
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel document = docCtx.getSourceDocument();
            CoreSession session = ctx.getCoreSession();
            if (document != null && !document.isImmutable() && document.hasSchema("toutatice_event")) {
                TTCDateSilentMerger runner = new TTCDateSilentMerger(session, document, eventName);
                runner.silentRun(false);
            }
        }
    }

    private class TTCDateSilentMerger
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;
        private String eventName;

        public TTCDateSilentMerger(CoreSession session, DocumentModel document, String eventName) {
            super(session);
            this.document = document;
            this.eventName = eventName;
        }

        public void run() throws ClientException {
            boolean isChangeableDocument = "documentCreated".equals(this.eventName);
            boolean toManage = false;
            WidgetsAdapterService waService = (WidgetsAdapterService)Framework.getService(WidgetsAdapterService.class);
            if (waService.isInPortalViewContext()) {
                toManage = this.mergeTTCDatesFields(toManage);
            }
            if (isChangeableDocument && toManage) {
                this.session.saveDocument(this.document);
            }
        }

        private boolean mergeTTCDatesFields(boolean toManage) {
            SimpleDateFormat format = new SimpleDateFormat(WidgetsTTCDatesMergeListener.DATE_TIME_FORMAT);
            String dateBegin = (String)((Object)this.document.getPropertyValue("ttcevt:dateBegin"));
            String timeBegin = (String)((Object)this.document.getPropertyValue("ttcevt:timeBegin"));
            if (StringUtils.isNotBlank((String)dateBegin)) {
                Date begin;
                if (StringUtils.isBlank((String)timeBegin)) {
                    timeBegin = WidgetsTTCDatesMergeListener.DEFAULT_TIME;
                }
                try {
                    begin = format.parse(new StringBuffer(3).append(dateBegin).append(" ").append(timeBegin).toString());
                }
                catch (ParseException e) {
                    throw new ClientException((Throwable)e);
                }
                this.document.setPropertyValue("ttcevt:dateTimeBegin", (Serializable)begin);
                toManage = true;
            }
            String dateEnd = (String)((Object)this.document.getPropertyValue("ttcevt:dateEnd"));
            String timeEnd = (String)((Object)this.document.getPropertyValue("ttcevt:timeEnd"));
            if (StringUtils.isNotBlank((String)dateEnd)) {
                Date end;
                if (StringUtils.isBlank((String)timeEnd)) {
                    timeEnd = WidgetsTTCDatesMergeListener.DEFAULT_TIME;
                }
                try {
                    end = format.parse(new StringBuffer(3).append(dateEnd).append(" ").append(timeEnd).toString());
                }
                catch (ParseException e) {
                    throw new ClientException((Throwable)e);
                }
                this.document.setPropertyValue("ttcevt:dateTimeEnd", (Serializable)end);
                toManage = true;
            }
            return toManage;
        }
    }
}

