/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.imagemanager;

import fr.toutatice.ecm.platform.service.url.ToutaticeDocumentLocation;
import fr.toutatice.ecm.platform.service.url.ToutaticeDocumentResolver;
import fr.toutatice.ecm.platform.service.url.WebIdRef;
import java.util.Collection;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.CollectionUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.picture.web.PictureManagerBean;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Name(value="pictureManager")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticePictureManagerBean
extends PictureManagerBean {
    private static final long serialVersionUID = 7735094004834523711L;

    public void download(DocumentView docView) throws ClientException {
        if (docView != null) {
            DocumentLocation docLoc = docView.getDocumentLocation();
            if (docLoc instanceof ToutaticeDocumentLocation) {
                ToutaticeDocumentLocation ttcDocLoc = (ToutaticeDocumentLocation)docLoc;
                WebIdRef webIdRef = ttcDocLoc.getWebIdRef();
                if (webIdRef != null) {
                    try {
                        this.downloadWebIdFile(docView, ttcDocLoc);
                    }
                    catch (DocumentException e) {
                        throw new ClientException((Throwable)e);
                    }
                }
            } else {
                super.download(docView);
            }
        }
    }

    protected void downloadWebIdFile(DocumentView docView, ToutaticeDocumentLocation docLoc) throws PropertyException, ClientException, DocumentException {
        DocumentModelList docs;
        if (this.documentManager == null) {
            RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
            this.navigationContext.setCurrentServerLocation(loc);
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
        }
        if (CollectionUtils.isNotEmpty((Collection)(docs = ToutaticeDocumentResolver.resolveReference((CoreSession)this.documentManager, (WebIdRef)docLoc.getWebIdRef()))) && docs.size() > 0) {
            DocumentModel doc = (DocumentModel)docs.get(0);
            String[] propertyPath = docView.getParameter("FILE_PROPERTY_PATH").split(":");
            String title = null;
            String field = null;
            Property datamodel = null;
            if (propertyPath.length == 2) {
                title = propertyPath[0];
                field = propertyPath[1];
                datamodel = doc.getProperty("picture:views");
            } else if (propertyPath.length == 3) {
                String schema = propertyPath[0];
                title = propertyPath[1];
                field = propertyPath[2];
                datamodel = doc.getProperty(schema + ":" + "views");
            }
            Property view = null;
            for (Property property : datamodel) {
                if (!property.get("title").getValue().equals(title)) continue;
                view = property;
            }
            if (view == null) {
                for (Property property : datamodel) {
                    if (!property.get("title").getValue().equals("Thumbnail")) continue;
                    view = property;
                }
            }
            if (view == null) {
                return;
            }
            Blob blob = (Blob)view.getValue(field);
            String filename = (String)((Object)view.getValue("filename"));
            FacesContext context = FacesContext.getCurrentInstance();
            ComponentUtils.download((FacesContext)context, (Blob)blob, (String)filename);
        }
    }
}

