/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="domainActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=30)
public class ToutaticeDomainActions
implements Serializable {
    private static final String TTCD_DEFAULT_PORTAL_SITE_ID = "ttcd:defaultPortalSiteId";
    private static final String PORTAL_SITE = "PortalSite";
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };
    private static final long serialVersionUID = 5069257071003926545L;
    @In(create=true, required=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;

    public void makeDefaultPortalSite() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        SilentUnrestrictedMakeDefaultPortal maker = new SilentUnrestrictedMakeDefaultPortal(this.documentManager, currentDocument);
        maker.silentRun(true, FILTERED_SERVICES_LIST);
    }

    public boolean canMakeDefaultPSite() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return currentDocument.getType().equals(PORTAL_SITE) && !this.isDefaultPortal(currentDocument);
    }

    public boolean showIsDefaultPSite() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return currentDocument.getType().equals(PORTAL_SITE) && this.isDefaultPortal(currentDocument);
    }

    private boolean isDefaultPortal(DocumentModel currentDocument) throws ClientException {
        UnrestrictedDefaultPortal runner = new UnrestrictedDefaultPortal(this.documentManager, currentDocument);
        runner.runUnrestricted();
        return runner.isDefault();
    }

    private class SilentUnrestrictedMakeDefaultPortal
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;

        public SilentUnrestrictedMakeDefaultPortal(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            if (this.document.getType().equals(ToutaticeDomainActions.PORTAL_SITE) && !ToutaticeDomainActions.this.isDefaultPortal(this.document)) {
                DocumentModel domain = ToutaticeDocumentHelper.getDomain((CoreSession)this.session, (DocumentModel)this.document, (boolean)false);
                domain.setPropertyValue(ToutaticeDomainActions.TTCD_DEFAULT_PORTAL_SITE_ID, (Serializable)((Object)this.document.getId()));
                this.session.saveDocument(domain);
            }
        }
    }

    private class UnrestrictedDefaultPortal
    extends UnrestrictedSessionRunner {
        private boolean defaultPortal;
        private DocumentModel document;

        public boolean isDefault() {
            return this.defaultPortal;
        }

        protected UnrestrictedDefaultPortal(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            DocumentModel domain = ToutaticeDocumentHelper.getDomain((CoreSession)this.session, (DocumentModel)this.document, (boolean)false);
            Serializable property = domain.getPropertyValue(ToutaticeDomainActions.TTCD_DEFAULT_PORTAL_SITE_ID);
            this.defaultPortal = property != null && property.toString().equals(this.document.getId());
        }
    }
}

