/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.userservices;

import fr.toutatice.ecm.platform.automation.SetWebID;
import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActionsBean;
import fr.toutatice.ecm.platform.web.local.configuration.WebConfsConfigurationActions;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;

@Name(value="toutaticeValidator")
@Scope(value=ScopeType.SESSION)
@Install(precedence=31)
public class ToutaticeValidatorBean
implements Serializable {
    private static final long serialVersionUID = -6136329151688755416L;
    private static final Log log = LogFactory.getLog(ToutaticeValidatorBean.class);
    private static final String DOMAIN_ID_UNICITY_QUERY = "select * from Domain where ecm:uuid <> '%s' and ttc:domainID = '%s' and ecm:currentLifeCycleState <> 'deleted'";
    @In(create=true, required=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient DocumentActions documentActions;
    final Pattern patternId = Pattern.compile("([a-zA-Z_0-9\\-\\_]+)");
    final Pattern patternExplicit = Pattern.compile("([a-zA-Z_0-9\\-\\/]+)");

    public void validateDomainIdUnicity(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String domainID = (String)value;
        if (StringUtils.isNotBlank((String)domainID)) {
            String msg = null;
            Matcher m = this.patternId.matcher(domainID);
            if (!m.matches()) {
                msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.validator.malformed.domainid");
            } else {
                DocumentModel currentDomain = null;
                try {
                    currentDomain = ((ToutaticeDocumentActionsBean)this.documentActions).getCurrentDocument();
                }
                catch (ClientException ce) {
                    msg = ce.getMessage();
                }
                if (currentDomain != null) {
                    String domainUUID = currentDomain.getId();
                    DocumentModelList domains = null;
                    try {
                        domains = this.documentManager.query(String.format(DOMAIN_ID_UNICITY_QUERY, domainUUID, domainID));
                    }
                    catch (ClientException e) {
                        msg = e.getMessage();
                    }
                    if (domains.size() > 0) {
                        msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.validator.not.single.domainId");
                    }
                } else {
                    msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.validator.no.domain");
                }
            }
            if (msg != null) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                throw new ValidatorException(message);
            }
        }
    }

    public void validateWebId(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String webId = (String)value;
        if (StringUtils.isNotBlank((String)webId)) {
            String msg = null;
            Matcher m = this.patternId.matcher(webId);
            if (!m.matches()) {
                msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.validator.malformed.webid");
            } else {
                DocumentModel doc = null;
                try {
                    doc = ((ToutaticeDocumentActionsBean)this.documentActions).getCurrentDocument();
                    if (doc != null) {
                        if (SetWebID.UnrestrictedSilentSetWebIdRunner.isNotUnique((CoreSession)this.documentManager, (DocumentModel)doc, (String)webId)) {
                            msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.validator.webid.no.unicity");
                        }
                    } else {
                        msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.validator.no.doc");
                    }
                }
                catch (ClientException ce) {
                    msg = ce.getMessage();
                }
            }
            if (msg != null) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                throw new ValidatorException(message);
            }
        }
    }

    public void validateExplicitUrl(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String explicitUrl = (String)value;
        if (StringUtils.isNotBlank((String)explicitUrl)) {
            String msg = null;
            Matcher m = this.patternExplicit.matcher(explicitUrl);
            if (!m.matches()) {
                msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.validator.malformed.explicit");
            }
            if (msg != null) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                throw new ValidatorException(message);
            }
        }
    }

    public void validateWebConfCode(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        UnrestrictedWebConfsChecker checker = new UnrestrictedWebConfsChecker(this.documentManager, context, value);
        checker.runUnrestricted();
    }

    private class UnrestrictedWebConfsChecker
    extends UnrestrictedSessionRunner {
        private FacesContext context;
        private Object value;

        protected UnrestrictedWebConfsChecker(CoreSession session, FacesContext context, Object value) {
            super(session);
            this.context = context;
            this.value = value;
        }

        public void run() throws ClientException {
            String msg = ComponentUtils.translate((FacesContext)this.context, (String)"osivia.label.validator.webConf.code");
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
            WebConfsConfigurationActions webConfsActions = (WebConfsConfigurationActions)SeamComponentCallHelper.getSeamComponentByName((String)"webConfsConfigurationActions");
            DocumentModel currentDomain = ToutaticeValidatorBean.this.navigationContext.getCurrentDomain();
            if (currentDomain != null) {
                if (currentDomain.hasFacet("WebConfigurationsLocalConfiguration")) {
                    Boolean allDeniedConfs = (Boolean)currentDomain.getPropertyValue("webconfs:denyAllConfsDocs");
                    if (BooleanUtils.isFalse((Boolean)allDeniedConfs)) {
                        List<String> selectedWebConfs;
                        List<DocumentModel> deniedWebConfs = webConfsActions.getNotSelectedConfs(currentDomain);
                        if (deniedWebConfs != null) {
                            for (DocumentModel selectedWebConf : deniedWebConfs) {
                                String code = (String)((Object)selectedWebConf.getPropertyValue("wconf:code"));
                                if (!code.equals((String)this.value)) continue;
                                throw new ValidatorException(message);
                            }
                        }
                        if ((selectedWebConfs = webConfsActions.getAllowedWebConfs(currentDomain)) != null && !selectedWebConfs.contains((String)this.value)) {
                            throw new ValidatorException(message);
                        }
                    }
                } else {
                    List<String> globalWebConfs = webConfsActions.getGlobalWebconfsCodes();
                    if (globalWebConfs != null && !globalWebConfs.isEmpty() && !globalWebConfs.contains((String)this.value)) {
                        String msg_ = ComponentUtils.translate((FacesContext)this.context, (String)"osivia.label.validator.webConf.global.code");
                        FacesMessage message_ = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg_, null);
                        throw new ValidatorException(message_);
                    }
                }
            }
        }
    }
}

