/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.workflows;

import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import fr.toutatice.ecm.platform.web.publication.ToutaticePublishActionsBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.publisher.web.PublishActionsBean;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.web.DocumentRoutingActionsBean;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

@Name(value="routingActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeDocumentRoutingActionsBean
extends DocumentRoutingActionsBean {
    private static final long serialVersionUID = 8176244997123301627L;
    private static final Log log = LogFactory.getLog(ToutaticeDocumentRoutingActionsBean.class);
    @In(create=true)
    PublishActionsBean publishActions;

    public String startOnlineWorkflow() throws ClientException {
        DocumentModel onlineWf = this.getOnlineWorkflowModel();
        return this.startWorkflow(onlineWf, "toutatice.label.online.wf.started");
    }

    public String startWorkflow(DocumentModel workflow, String msgKey) {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        ArrayList<String> currentDocIds = new ArrayList<String>(1);
        currentDocIds.add(currentDoc.getId());
        this.getDocumentRoutingService().createNewInstance(workflow.getName(), currentDocIds, this.documentManager, true);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{workflow});
        FacesMessages.instance().addFromResourceBundle(msgKey, new Object[0]);
        this.webActions.resetTabList();
        return null;
    }

    public Task getValidateTask(String wfName) throws ClientException {
        Task validate = null;
        String taskName = "";
        if ("toutatice_online_approbation".equals(wfName)) {
            taskName = "validate-online";
        }
        if (StringUtils.isNotBlank((String)taskName)) {
            List currentRouteAllTasks = this.getCurrentRouteAllTasks();
            Iterator iterator = currentRouteAllTasks.iterator();
            while (iterator.hasNext() && validate == null) {
                Task task = (Task)iterator.next();
                if (!taskName.equalsIgnoreCase(task.getName())) continue;
                validate = task;
            }
        }
        return validate;
    }

    private DocumentModel getOnlineWorkflowModel() throws ClientException {
        String id = this.getDocumentRoutingService().getRouteModelDocIdWithId(this.documentManager, "toutatice_online_approbation");
        return this.getRouteModel(id);
    }

    public boolean isWorkflowRunning() throws ClientException {
        List relatedRoutes = this.getRelatedRoutes();
        return relatedRoutes != null && !relatedRoutes.isEmpty();
    }

    public boolean isWorkflowRunningForSelection() throws ClientException {
        List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        return this.isWorkflowRunningForSelection(currentDocumentSelection);
    }

    private boolean isWorkflowRunningForSelection(List<DocumentModel> selection) throws ClientException {
        boolean status = false;
        for (DocumentModel document : selection) {
            if (!this.isWorkflowRunningForDocument(document)) continue;
            status = true;
            break;
        }
        return status;
    }

    public boolean isWorkflowRunningForDocument(DocumentModel document) throws ClientException {
        List documentRoutes = this.getDocumentRoutingService().getDocumentRoutesForAttachedDocument(this.documentManager, document.getId());
        return documentRoutes != null && !documentRoutes.isEmpty();
    }

    public boolean isCancelOnlineActionAuthorized() throws ClientException {
        boolean doWorkflowExist = false;
        boolean isUserInitiator = false;
        try {
            doWorkflowExist = this.isOnLineWorkflowRunning();
            NuxeoPrincipal principal = this.currentUser;
            isUserInitiator = principal.getName().equals(this.getCurrentWorkflowInitiator());
        }
        catch (Exception e) {
            log.debug((Object)("Failed to execute 'isCancelOnlineActionAuthorized()', error: " + e.getMessage()));
        }
        return doWorkflowExist && isUserInitiator;
    }

    public boolean isOnLineWorkflowRunning() {
        return this.getOnlineWorkflow() != null;
    }

    public boolean isDirectSetOnlineActionAuthorized() throws ClientException {
        boolean isAuthorized = false;
        try {
            String currentLifeCycle = ((ToutaticeNavigationContext)this.navigationContext).getCurrentLifeCycleState();
            boolean isInProjectState = "project".equals(currentLifeCycle);
            boolean isInOnlineWf = this.isOnLineWorkflowRunning();
            isAuthorized = isInProjectState && !isInOnlineWf;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to execute 'isDirectSetOnlineActionAuthorized()', error: " + e.getMessage()));
        }
        return isAuthorized;
    }

    public String getPendingWorkflowName() throws ClientException {
        String name = "";
        DocumentRoute relatedRoute = this.getRelatedRoute();
        if (relatedRoute != null) {
            name = relatedRoute.getName();
        } else if (((ToutaticePublishActionsBean)this.publishActions).isPending()) {
            name = "remote_publication_process";
        }
        return name;
    }

    public String cancelOnlineWorkflow() throws ClientException {
        return this.cancelWorkflow("toutatice_online_approbation");
    }

    public String cancelRoute() throws ClientException {
        Events.instance().raiseEvent("beforeWorkflowProcessCanceled", new Object[0]);
        return super.cancelRoute();
    }

    public String cancelWorkflow(String wfName) throws ClientException {
        List routes = this.getRelatedRoutes();
        if (routes.size() == 0) {
            log.error((Object)"No workflow to cancel");
            return null;
        }
        DocumentRoute route = this.getRunningWorkflowByName(routes, wfName);
        Task validateTask = this.getValidateTask(wfName);
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        ToutaticeWorkflowHelper.notifyRecipients((CoreSession)this.documentManager, (Task)validateTask, (DocumentModel)currentDoc, null, (String)"workflowOnlineCanceled");
        ((DocumentRoutingEngineService)Framework.getLocalService(DocumentRoutingEngineService.class)).cancel(route, this.documentManager);
        this.webActions.resetTabList();
        Events.instance().raiseEvent("workflowProcessCanceled", new Object[0]);
        Contexts.removeFromAllContexts((String)"relatedRoutes");
        this.documentManager.save();
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
    }

    public DocumentRoute getOnlineWorkflow() {
        List routes = this.getRelatedRoutes();
        return this.getRunningWorkflowByName(routes, "toutatice_online_approbation");
    }

    public DocumentRoute getRunningWorkflowByName(List<DocumentRoute> routes, String workflowName) {
        DocumentRoute onlineRoute = null;
        if (routes != null) {
            Iterator<DocumentRoute> iterator = routes.iterator();
            while (iterator.hasNext() && onlineRoute == null) {
                DocumentRoute route = iterator.next();
                if (!workflowName.equals(route.getName())) continue;
                onlineRoute = route;
            }
        }
        return onlineRoute;
    }

    public boolean isOnLineWfPending(DocumentModel document) throws ClientException {
        return ToutaticeWorkflowHelper.isOnLineWorkflow((DocumentModel)document);
    }
}

