/**
 * 
 */
package org.osivia.procedures.es.customizer.writer;

import java.io.IOException;
import java.util.Map;

import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.osivia.procedures.constants.ProceduresConstants;
import org.osivia.procedures.es.customizer.writer.helper.DenormalizationJsonESWriterHelper;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;


/**
 * @author david
 *
 */
public class ProcedureInstanceJsonESWriter extends AbstractCustomJsonESWriter {

    /**
     * Default constructor.
     */
    public ProcedureInstanceJsonESWriter() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean accept(DocumentModel doc) {
        return ProceduresConstants.PI_TYPE.equals(doc.getType());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void writeData(JsonGenerator jg, DocumentModel pi, String[] schemas, Map<String, String> contextParameters) throws IOException {
        // Custom name /value
        DenormalizationJsonESWriterHelper.mapKeyValue(jg, pi, ProceduresConstants.PI_VALUES_XPATH, 
                ProceduresConstants.PI_ENTRY_KEY, ProceduresConstants.ENTRY_VALUE);
    }

}
