/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.addon.quota.automation;

import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.opentoutatice.addon.quota.check.util.BlobsSizeComputer;
import org.opentoutatice.addon.quota.check.util.QuotaResolver;

@Operation(id="Quota.GetInfo")
public class QuotaInfo {
    public static final String ID = "Quota.GetInfo";
    private static final Log log = LogFactory.getLog(QuotaInfo.class);
    @Context
    protected CoreSession session;

    @OperationMethod
    public Object run(DocumentRef docRef) throws ClientException {
        JSONObject QuotaItems = new JSONObject();
        DocumentModel document = this.session.getDocument(docRef);
        Long treeSize = BlobsSizeComputer.get().getTreeSizeFrom(this.session, docRef);
        QuotaItems.put((Object)"treesize", (Object)treeSize);
        long quotaValue = QuotaResolver.get().getQuotaFor(this.session, document, true);
        QuotaItems.put((Object)"quota", (Object)quotaValue);
        return this.createBlob(QuotaItems);
    }

    private Blob createBlob(JSONObject json) {
        return new StringBlob(json.toString(), "application/json");
    }
}

