/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.text.FastURLDecoder;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.common.util.ParameterValidation;

public class URLTools {
    public static final String RE_EMAIL_VALIDATION = "^([a-zA-Z0-9]+(([\\.\\-\\_]?[a-zA-Z0-9]+)+)?)\\@(([a-zA-Z0-9]+[\\.\\-\\_])+[a-zA-Z]{2,4})$";
    private static final Pattern LINK = Pattern.compile("(?:href|action|src|location)\\s*=\\s*('|\")\\s*([^'\"]*)\\s*('|\")", 2);
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";
    public static final String FTP_PREFIX = "ftp://";
    public static final String FILE_PREFIX = "/";
    private static final Logger log = Logger.getLogger(URLTools.class);

    public static boolean isURLAbsolute(String url) {
        return URLTools.isNetworkURL(url) || url.startsWith(FILE_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(URL url, int soTimeoutMillis, int connTimeoutMillis) throws IllegalArgumentException {
        byte[] byArray;
        InputStream in = null;
        try {
            in = URLTools.getContentAsInputStream(url, soTimeoutMillis, connTimeoutMillis);
            byArray = IOTools.getBytes(in);
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOTools.safeClose(in);
                throw throwable;
            }
            IOTools.safeClose(in);
            return byArray2;
        }
        IOTools.safeClose(in);
        return byArray;
    }

    public static InputStream getContentAsInputStream(URL url, int soTimeoutMillis, int connTimeoutMillis) throws IOException {
        URLConnection conn;
        if (url == null) {
            throw new IllegalArgumentException();
        }
        if (soTimeoutMillis < 0) {
            throw new IllegalArgumentException("No negative socket timeout " + soTimeoutMillis);
        }
        if (connTimeoutMillis < 0) {
            throw new IllegalArgumentException("No negative connection timeout" + connTimeoutMillis);
        }
        if (System.getProperty("http.proxyUser") != null) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword").toCharArray());
                }
            });
        }
        try {
            conn = url.openConnection();
        }
        catch (IOException e) {
            return null;
        }
        conn.setConnectTimeout(soTimeoutMillis);
        conn.setReadTimeout(connTimeoutMillis);
        conn.connect();
        try {
            return new BufferedInputStream(conn.getInputStream());
        }
        catch (SocketTimeoutException e) {
            log.debug((Object)("Time out on: " + url));
            throw e;
        }
    }

    public static boolean isNetworkURL(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        return url.startsWith(HTTP_PREFIX) || url.startsWith(HTTPS_PREFIX) || url.startsWith(FTP_PREFIX);
    }

    public static void enforceAbsoluteURL(String url) throws IllegalArgumentException {
        if (!URLTools.isURLAbsolute(url)) {
            throw new IllegalArgumentException("URL must be absolute. Was: " + url);
        }
    }

    public static String encodeXWWWFormURL(String s) {
        return FastURLEncoder.getUTF8Instance().encode(s);
    }

    public static String decodeXWWWFormURL(String s) {
        return FastURLDecoder.getUTF8Instance().encode(s);
    }

    public static boolean isEmailValid(String address) {
        return address != null && Pattern.matches(RE_EMAIL_VALIDATION, address);
    }

    public static boolean exists(URL url) {
        return URLTools.exists(url, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean exists(URL url, long waitForMillis) throws IllegalArgumentException {
        boolean bl;
        URLConnection conn;
        if (url == null) {
            throw new IllegalArgumentException("No null URL accepted");
        }
        if (waitForMillis < 0L) {
            throw new IllegalArgumentException("Read time out must be a positive value instead of " + waitForMillis);
        }
        try {
            conn = url.openConnection();
        }
        catch (IOException e) {
            log.debug((Object)("Could not open connection for " + url), (Throwable)e);
            return false;
        }
        conn.setConnectTimeout((int)waitForMillis);
        conn.setReadTimeout((int)waitForMillis);
        InputStream in = null;
        try {
            conn.connect();
            in = conn.getInputStream();
            bl = true;
        }
        catch (SocketTimeoutException e) {
            boolean bl2 = false;
            IOTools.safeClose(in);
            return bl2;
        }
        catch (IOException e2) {
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    IOTools.safeClose(in);
                    throw throwable;
                }
            }
            IOTools.safeClose(in);
            return bl3;
        }
        IOTools.safeClose(in);
        return bl;
    }

    public static boolean exists(String stringURL, boolean allowNull) {
        if (!allowNull) {
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(stringURL, "URL", null);
        }
        try {
            URL url = new URL(stringURL);
            return URLTools.exists(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static URLMatch[] extractURLsFrom(String markup) {
        int length;
        if (markup != null && (length = markup.length()) != 0) {
            Matcher matcher = LINK.matcher(markup);
            int currentIndex = 0;
            ArrayList<URLMatch> links = new ArrayList<URLMatch>();
            while (matcher.find(currentIndex) && currentIndex < length) {
                links.add(new URLMatch(matcher.start(2), matcher.end(2), matcher.group(2)));
                currentIndex = matcher.end();
            }
            return links.toArray(new URLMatch[0]);
        }
        throw new IllegalArgumentException("Cannot extract URLs from a null or empty markup string!");
    }

    public static int getURLCountIn(String markup) {
        int length;
        if (markup != null && (length = markup.length()) != 0) {
            Matcher matcher = LINK.matcher(markup);
            int count = 0;
            int currentIndex = 0;
            while (matcher.find(currentIndex) && currentIndex < length) {
                ++count;
                currentIndex = matcher.end();
            }
            return count;
        }
        return 0;
    }

    public static String replaceURLsBy(String markup, final String[] replacements) {
        if (replacements == null || replacements.length == 0) {
            return markup;
        }
        int urlCount = URLTools.getURLCountIn(markup);
        if (replacements.length != urlCount) {
            throw new IllegalArgumentException("Trying to replace " + urlCount + " URLs by " + replacements.length + " replacement(s).");
        }
        return URLTools.replaceURLsBy(markup, new URLReplacementGenerator(){

            public String getReplacementFor(int currentIndex, URLMatch currentMatch) {
                return replacements[currentIndex];
            }
        });
    }

    public static String replaceURLsBy(String markup, URLReplacementGenerator generator) {
        URLMatch[] urls = URLTools.extractURLsFrom(markup);
        if (urls.length > 0) {
            StringBuffer newMarkup = new StringBuffer(markup.length());
            int currentIndex = 0;
            for (int i = 0; i < urls.length; ++i) {
                URLMatch url = urls[i];
                newMarkup.append(markup.substring(currentIndex, url.getStart())).append(generator.getReplacementFor(i, url));
                currentIndex = url.getEnd();
            }
            newMarkup.append(markup.substring(currentIndex));
            markup = newMarkup.toString();
        }
        return markup;
    }

    public static String replaceServerPortInURL(String url, int newPort) {
        if (!URLTools.isNetworkURL(url)) {
            return url;
        }
        StringBuffer buf = new StringBuffer(url);
        int afterProtocol = url.indexOf("://") + 3;
        int beforePort = url.indexOf(58, afterProtocol);
        if (beforePort != -1) {
            int afterPort = url.indexOf(47, beforePort);
            buf.delete(beforePort + 1, afterPort);
            buf.insert(beforePort + 1, newPort);
        } else {
            int afterPort = url.indexOf(47, afterProtocol);
            buf.insert(afterPort, ":" + newPort);
        }
        return buf.toString();
    }

    public static class PortReplacementGenerator
    extends URLReplacementGenerator {
        private int replacementPort;

        public PortReplacementGenerator(int replacementPort) {
            this.replacementPort = replacementPort;
        }

        public String getReplacementFor(int currentIndex, URLMatch currentMatch) {
            return URLTools.replaceServerPortInURL(currentMatch.getURLAsString(), this.replacementPort);
        }
    }

    public static abstract class URLReplacementGenerator {
        public abstract String getReplacementFor(int var1, URLMatch var2);
    }

    public static class URLMatch {
        private int start;
        private int end;
        private String urlAsString;

        private URLMatch(int start, int end, String urlAsString) {
            this.start = start;
            this.end = end;
            this.urlAsString = urlAsString;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getURLAsString() {
            return this.urlAsString;
        }
    }
}

