/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ParameterValidation {
    public static final Pattern CSS_DISTANCE = Pattern.compile("\\d+\\W*(em|ex|px|in|cm|mm|pt|pc|%)?");
    public static final Pattern XSS_CHECK = Pattern.compile("([^<>\\(\\)=\\\\](?<!%5C))*", 2);

    public static void throwIllegalArgExceptionIfNullOrEmpty(String valueToCheck, String valueName, String contextName) {
        if (ParameterValidation.isNullOrEmpty(valueToCheck)) {
            throw new IllegalArgumentException((contextName != null ? contextName + " r" : "R") + "equires a non-null, non-empty " + valueName);
        }
    }

    public static void throwIllegalArgExceptionIfRangeInvalid(char[] chars, int offset, int length) {
        ParameterValidation.throwIllegalArgExceptionIfNull(chars, "characters");
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be positive!");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must be positive!");
        }
        if (offset + length > chars.length) {
            throw new IllegalArgumentException("Specified character range is outside of the given char[]!");
        }
    }

    public static boolean isNullOrEmpty(String valueToCheck) {
        return valueToCheck == null || valueToCheck.trim().length() == 0;
    }

    public static void throwIllegalArgExceptionIfNull(Object objectToTest, String name) {
        if (objectToTest == null) {
            throw new IllegalArgumentException("Must pass a non null " + name);
        }
    }

    public static void throwIllegalArgExceptionIfNullOrEmpty(Object[] array, String name) {
        if (array == null) {
            throw new IllegalArgumentException("Must pass a non-null " + name);
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Must pass a non-empty " + name);
        }
    }

    public static String sanitizeFromPattern(String value, Pattern regex, String defaultValue) {
        return ParameterValidation.sanitizeFromPatternWithHandler(value, regex, new LoggingValidationErrorHandler(defaultValue, null));
    }

    public static String sanitizeFromPatternWithHandler(String value, Pattern regex, ValidationErrorHandler handler) {
        ParameterValidation.throwIllegalArgExceptionIfNull(regex, "expected value format");
        ParameterValidation.throwIllegalArgExceptionIfNull(handler, "ValidationErrorHandler");
        if (value == null || !regex.matcher(value).matches()) {
            return handler.handleValidationError(value);
        }
        return value;
    }

    public static String sanitizeFromValues(String value, String[] possibleValues, String defaultValue) {
        return ParameterValidation.sanitizeFromValuesWithHandler(value, possibleValues, new LoggingValidationErrorHandler(defaultValue, null));
    }

    public static String sanitizeFromValuesWithHandler(String value, String[] possibleValues, ValidationErrorHandler handler) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(possibleValues, "possible values");
        ParameterValidation.throwIllegalArgExceptionIfNull(handler, "ValidationErrorHandler");
        List<String> values = Arrays.asList(possibleValues);
        if (!values.contains(value)) {
            return handler.handleValidationError(value);
        }
        return value;
    }

    public static class LoggingValidationErrorHandler
    extends ValidationErrorHandler {
        private static final Logger log = Logger.getLogger(ParameterValidation.class);
        private String contextMessage;

        public LoggingValidationErrorHandler(String defaultValue, String contextMessage) {
            super(defaultValue);
            this.contextMessage = contextMessage;
        }

        protected String internalValidationErrorHandling(String failedValue) {
            log.debug((Object)("'" + failedValue + "' failed validation." + (this.contextMessage != null ? "\n" + this.contextMessage : "")));
            return "__JBP__CONTINUE__";
        }
    }

    public static abstract class ValidationErrorHandler {
        private ValidationErrorHandler next;
        private String defaultValue;
        protected static final String CONTINUE = "__JBP__CONTINUE__";

        public ValidationErrorHandler(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public ValidationErrorHandler setNext(ValidationErrorHandler next) {
            this.next = next;
            return this;
        }

        public String handleValidationError(String failedValue) {
            String result = this.internalValidationErrorHandling(failedValue);
            if (!CONTINUE.equals(result)) {
                return result;
            }
            if (this.next != null) {
                return this.next.handleValidationError(failedValue);
            }
            return this.defaultValue;
        }

        protected abstract String internalValidationErrorHandling(String var1);
    }
}

