/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

public class Version {
    private final String codeName;
    private final String toString;
    private final String name;
    private final int major;
    private final int minor;
    private final int patch;
    private final Qualifier qualifier;

    public Version(String name, int major, int minor, int patch, Qualifier qualifier, String codeName) {
        if (name == null) {
            throw new IllegalArgumentException("No name provided");
        }
        if (major < 0) {
            throw new IllegalArgumentException("Major cannot be negative");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("Minor cannot be negative");
        }
        if (patch < 0) {
            throw new IllegalArgumentException("Patch cannot be negative");
        }
        if (qualifier == null) {
            throw new IllegalArgumentException("Qualifier cannot be null");
        }
        if (codeName == null) {
            throw new IllegalArgumentException("No code name provided");
        }
        this.name = name;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
        this.codeName = codeName;
        this.toString = Format.JBOSS_PRODUCT_CONVENTION.toString(this);
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getName() {
        return this.name;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return this.toString;
    }

    public String toString(Format format) throws IllegalArgumentException {
        if (format == null) {
            throw new IllegalArgumentException();
        }
        return format.toString(this);
    }

    public static interface Format {
        public static final Format JBOSS_PRODUCT_CONVENTION = new Format(){

            public String toString(Version version) {
                StringBuffer buffer = new StringBuffer(version.getName());
                buffer.append(" ").append(version.getMajor()).append('.').append(version.getMinor()).append('.').append(version.getPatch()).append('-').append(version.getQualifier());
                return buffer.toString();
            }
        };

        public String toString(Version var1);
    }

    public static class Qualifier {
        private final String toString;
        private final Prefix prefix;
        private final Suffix suffix;

        public Qualifier(Prefix prefix) {
            this(prefix, Suffix.EMPTY);
        }

        public Qualifier(Prefix prefix, Suffix suffix) {
            if (prefix == null) {
                throw new IllegalArgumentException("No prefix provided");
            }
            if (suffix == null) {
                suffix = Suffix.EMPTY;
            }
            if (!prefix.isSuffixable() && suffix.value.length() > 0) {
                throw new IllegalArgumentException("The prefix " + (Object)((Object)prefix) + " is not suffixable");
            }
            this.toString = "" + (Object)((Object)prefix) + (Object)((Object)suffix);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public Prefix getPrefix() {
            return this.prefix;
        }

        public Suffix getSuffix() {
            return this.suffix;
        }

        public String toString() {
            return this.toString;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Suffix {
            EMPTY(""),
            SUFFIX_1("1"),
            SUFFIX_2("2"),
            SUFFIX_3("3"),
            SUFFIX_4("4"),
            SUFFIX_5("5"),
            SUFFIX_6("6");

            private final String value;

            private Suffix(String value) {
                this.value = value;
            }

            public String toString() {
                return this.value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Prefix {
            SNAPSHOT("SNAPSHOT", false, "Snapshot"),
            ALPHA("ALPHA", true, "Alpha"),
            BETA("BETA", true, "Beta"),
            CR("CR", true, "Candidate for release"),
            GA("GA", false, "General Availability"),
            SP("SP", true, "Service pack");

            private final String name;
            private final String description;
            private final boolean suffixable;

            private Prefix(String name, boolean suffixable, String description) {
                this.name = name;
                this.suffixable = suffixable;
                this.description = description;
            }

            public String getName() {
                return this.name;
            }

            public boolean isSuffixable() {
                return this.suffixable;
            }

            public String getDescription() {
                return this.description;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

