/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.connect.tools.report.ReportRunner;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="report")
public class ReportRunnerObject
extends DefaultObject {
    ReportRunner runner = (ReportRunner)Framework.getService(ReportRunner.class);
    List<String> list = new ArrayList<String>(this.runner.list());
    List<String> selection = new ArrayList<String>(this.list);

    @GET
    @Produces(value={"text/html"})
    public Template index(@Context UriInfo info) {
        return this.getView("index");
    }

    @POST
    @Path(value="run")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/json"})
    public Response run(@FormParam(value="reports") List<String> reports) throws IOException {
        this.selection = reports;
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream sink) throws IOException, WebApplicationException {
                ReportRunnerObject.this.runner.run(sink, new HashSet<String>(ReportRunnerObject.this.selection));
            }
        };
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=nuxeo-connect-tools-report.json").build();
    }

    public List<String> availables() {
        return this.list;
    }

    public boolean isSelected(String report) {
        return this.selection.contains(report);
    }

    public String toString() {
        return "Report runner of " + this.selection;
    }
}

