/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.RequestRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.servlet.ProxyBase;
import org.apache.shindig.gadgets.servlet.ProxyHandler;

@Singleton
public class NXProxyHandler
extends ProxyBase {
    private static final String ACCEPT_LANGUAGE = "Accept-Language";
    private static final Logger logger = Logger.getLogger(ProxyHandler.class.getName());
    private static final String[] INTEGER_RESIZE_PARAMS = new String[]{"resize_h", "resize_w", "resize_q", "no_expand"};
    static final String FALLBACK_URL_PARAM = "fallback_url";
    private final RequestPipeline requestPipeline;
    private final LockedDomainService lockedDomainService;
    private final RequestRewriterRegistry contentRewriterRegistry;

    @Inject
    public NXProxyHandler(RequestPipeline requestPipeline, LockedDomainService lockedDomainService, RequestRewriterRegistry contentRewriterRegistry) {
        this.requestPipeline = requestPipeline;
        this.lockedDomainService = lockedDomainService;
        this.contentRewriterRegistry = contentRewriterRegistry;
    }

    private HttpRequest nxbuildHttpRequest(HttpServletRequest request, String urlParam) throws GadgetException {
        String acceptLanguage;
        String theUrl = request.getParameter(urlParam);
        if (theUrl == null) {
            return null;
        }
        Uri url = this.validateUrl(theUrl);
        HttpRequest req = new HttpRequest(url).setContainer(this.getContainer(request));
        this.copySanitizedIntegerParams(request, req);
        if (request.getParameter("gadget") != null) {
            req.setGadget(Uri.parse((String)request.getParameter("gadget")));
        }
        if ((acceptLanguage = request.getHeader(ACCEPT_LANGUAGE)) != null) {
            req.setHeader(ACCEPT_LANGUAGE, acceptLanguage);
        }
        req.setRewriteMimeType(request.getParameter("rewriteMime"));
        req.setIgnoreCache(this.getIgnoreCache(request));
        req.setSanitizationRequested("1".equals(request.getParameter("sanitize")));
        if (request.getParameter("refresh") != null) {
            try {
                req.setCacheTtl(Integer.parseInt(request.getParameter("refresh")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setRequestHeaders(request, req);
        return req;
    }

    private void copySanitizedIntegerParams(HttpServletRequest request, HttpRequest req) {
        for (String resizeParamName : INTEGER_RESIZE_PARAMS) {
            if (request.getParameter(resizeParamName) == null) continue;
            req.setParam(resizeParamName, (Object)NumberUtils.createInteger((String)request.getParameter(resizeParamName)));
        }
    }

    protected void doFetch(HttpServletRequest request, HttpServletResponse response) throws IOException, GadgetException {
        HttpRequest fallbackRcr;
        if (request.getHeader("If-Modified-Since") != null) {
            response.setStatus(304);
            return;
        }
        String host = request.getHeader("Host");
        if (!this.lockedDomainService.isSafeForOpenProxy(host)) {
            String msg = "Embed request for url " + this.getParameter(request, "url", "") + " made to wrong domain " + host;
            logger.info(msg);
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, msg);
        }
        HttpRequest rcr = this.nxbuildHttpRequest(request, "url");
        HttpResponse results = this.requestPipeline.execute(rcr);
        if (results.isError() && (fallbackRcr = this.nxbuildHttpRequest(request, FALLBACK_URL_PARAM)) != null) {
            results = this.requestPipeline.execute(fallbackRcr);
        }
        if (this.contentRewriterRegistry != null) {
            try {
                results = this.contentRewriterRegistry.rewriteHttpResponse(rcr, results);
            }
            catch (RewritingException e) {
                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        for (Map.Entry entry : results.getHeaders().entries()) {
            String name = (String)entry.getKey();
            if (DISALLOWED_RESPONSE_HEADERS.contains(name.toLowerCase())) continue;
            response.addHeader(name, (String)entry.getValue());
        }
        String responseType = results.getHeader("Content-Type");
        if (!StringUtils.isEmpty((String)rcr.getRewriteMimeType())) {
            String requiredType = rcr.getRewriteMimeType();
            if (requiredType.endsWith("/*") && !StringUtils.isEmpty((String)responseType)) {
                requiredType = requiredType.substring(0, requiredType.length() - 2);
                if (!responseType.toLowerCase().startsWith(requiredType.toLowerCase())) {
                    response.setContentType(requiredType);
                    responseType = requiredType;
                }
            } else {
                response.setContentType(requiredType);
                responseType = requiredType;
            }
        }
        this.setResponseHeaders(request, response, results);
        if (results.getHttpStatusCode() != 200) {
            response.sendError(results.getHttpStatusCode());
        }
        IOUtils.copy((InputStream)results.getResponse(), (OutputStream)response.getOutputStream());
    }
}

