/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.gadgets;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.nuxeo.opensocial.helper.ProxyHelper;

public class NXHttpFetcher
implements HttpFetcher {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    private static final int DEFAULT_MAX_OBJECT_SIZE = 0;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private volatile int maxObjSize;
    private volatile int connectionTimeoutMs;

    public NXHttpFetcher(int maxObjSize, int connectionTimeoutMs) {
        this.setMaxObjectSizeBytes(maxObjSize);
        this.setConnectionTimeoutMs(connectionTimeoutMs);
    }

    public NXHttpFetcher() {
        this(0, 5000);
    }

    @Inject(optional=true)
    public void setMaxObjectSizeBytes(@Named(value="shindig.http.client.max-object-size-bytes") int maxObjectSizeBytes) {
        this.maxObjSize = maxObjectSizeBytes;
    }

    @Inject(optional=true)
    public void setConnectionTimeoutMs(@Named(value="shindig.http.client.connection-timeout-ms") int connectionTimeoutMs) {
        Preconditions.checkArgument((connectionTimeoutMs > 0 ? 1 : 0) != 0, (Object)"connection-timeout-ms must be greater than 0");
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    private HttpResponse makeResponse(HttpMethod httpMethod, int responseCode) throws IOException {
        int currentBytesRead;
        HashMap headers = Maps.newHashMap();
        if (httpMethod.getResponseHeaders() != null) {
            for (Header h : httpMethod.getResponseHeaders()) {
                headers.put(h.getName(), h.getValue());
            }
        }
        headers.remove(null);
        InputStream responseBodyStream = null;
        try {
            responseBodyStream = httpMethod.getResponseBodyAsStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (responseBodyStream == null) {
            responseBodyStream = new ByteArrayInputStream(ArrayUtils.EMPTY_BYTE_ARRAY);
        }
        String encoding = (String)headers.get("Content-Encoding");
        InputStream is = responseBodyStream;
        if (encoding == null) {
            is = responseBodyStream;
        } else if (encoding.equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(responseBodyStream);
        } else if (encoding.equalsIgnoreCase("deflate")) {
            Inflater inflater = new Inflater(true);
            is = new InflaterInputStream(responseBodyStream, inflater);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int totalBytesRead = 0;
        while ((currentBytesRead = is.read(buffer)) != -1) {
            output.write(buffer, 0, currentBytesRead);
            if (this.maxObjSize <= 0 || (totalBytesRead += currentBytesRead) <= this.maxObjSize) continue;
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)output);
            return HttpResponse.badrequest((String)("Exceeded maximum number of bytes - " + this.maxObjSize));
        }
        return new HttpResponseBuilder().setHttpStatusCode(responseCode).setResponse(output.toByteArray()).addHeaders((Map)headers).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse fetch(HttpRequest request) {
        Object httpMethod;
        HttpClient httpClient = new HttpClient();
        String methodType = request.getMethod();
        String requestUri = request.getUri().toString();
        ProxyHelper.fillProxy(httpClient, requestUri);
        boolean requestCompressedContent = true;
        if ("POST".equals(methodType) || "PUT".equals(methodType)) {
            Object enclosingMethod;
            Object object = enclosingMethod = "POST".equals(methodType) ? new PostMethod(requestUri) : new PutMethod(requestUri);
            if (request.getPostBodyLength() > 0) {
                enclosingMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(request.getPostBody()));
                enclosingMethod.setRequestHeader("Content-Length", String.valueOf(request.getPostBodyLength()));
            }
            httpMethod = enclosingMethod;
        } else {
            httpMethod = "DELETE".equals(methodType) ? new DeleteMethod(requestUri) : ("HEAD".equals(methodType) ? new HeadMethod(requestUri) : new GetMethod(requestUri));
        }
        httpMethod.setFollowRedirects(false);
        httpMethod.getParams().setSoTimeout(this.connectionTimeoutMs);
        httpMethod.setRequestHeader("Connection", "close");
        if (requestCompressedContent) {
            httpMethod.setRequestHeader("Accept-Encoding", "gzip, deflate");
        }
        for (Map.Entry httpResponse : request.getHeaders().entrySet()) {
            httpMethod.setRequestHeader((String)httpResponse.getKey(), StringUtils.join((Collection)((Collection)httpResponse.getValue()), (char)','));
        }
        try {
            Header header;
            int statusCode = httpClient.executeMethod((HttpMethod)httpMethod);
            if (request.getFollowRedirects() && (statusCode == 302 || statusCode == 301 || statusCode == 303 || statusCode == 307) && (header = httpMethod.getResponseHeader("location")) != null) {
                String redirectUri = header.getValue();
                if (redirectUri == null || redirectUri.equals("")) {
                    redirectUri = "/";
                }
                httpMethod.releaseConnection();
                httpMethod = new GetMethod(redirectUri);
                statusCode = httpClient.executeMethod((HttpMethod)httpMethod);
            }
            HttpResponse httpResponse = this.makeResponse((HttpMethod)httpMethod, statusCode);
            return httpResponse;
        }
        catch (IOException e) {
            if (e instanceof SocketTimeoutException || e instanceof SocketException) {
                HttpResponse httpResponse = HttpResponse.timeout();
                return httpResponse;
            }
            HttpResponse httpResponse = HttpResponse.error();
            return httpResponse;
        }
        finally {
            httpMethod.releaseConnection();
        }
    }
}

