/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.gwt;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.gwt.GwtResolver;
import org.nuxeo.runtime.api.Framework;

public class WebEngineGwtServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(WebEngineGwtServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        try {
            return this._doGetSerializationPolicy(request, moduleBaseURL, strongName);
        }
        catch (FileNotFoundException cause) {
            throw new NuxeoException("Cannot find serialization policy for " + moduleBaseURL, (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializationPolicy _doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) throws FileNotFoundException {
        String moduleId;
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                log.warn((Object)("Malformed moduleBaseURL: " + moduleBaseURL), (Throwable)ex);
                return super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
            }
        }
        if ((moduleId = new File(modulePath).getName()).length() == 0) {
            moduleId = "root";
        }
        String filename = SerializationPolicyLoader.getSerializationPolicyFileName((String)strongName);
        File policyFile = ((GwtResolver)Framework.getService(GwtResolver.class)).resolve(moduleId + "/" + filename);
        if (policyFile == null || !policyFile.isFile()) {
            log.warn((Object)("Could not find gwt serialization policy file for module " + moduleId + " [ " + filename + " ]"));
            return super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
        }
        log.debug((Object)("Found gwt serialization policy file: " + policyFile));
        FileInputStream in = null;
        try {
            in = new FileInputStream(policyFile);
            SerializationPolicy serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)in, null);
            return serializationPolicy;
        }
        catch (IOException e) {
            log.error((Object)("Failed to read gwt serialization policy file for module " + moduleId + " [ " + filename + " ]"), (Throwable)e);
            SerializationPolicy serializationPolicy = super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
            return serializationPolicy;
        }
        catch (ParseException e) {
            log.error((Object)("Failed to parse the policy file '" + policyFile + "'"), (Throwable)e);
            SerializationPolicy serializationPolicy = super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
            return serializationPolicy;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

