/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.acl;

import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.runtime.api.Framework;

public class ACLUpdateListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if ("beforeDocumentSecurityModification".equals(event.getName())) {
            MultiTenantService mts = (MultiTenantService)Framework.getService(MultiTenantService.class);
            if (!mts.isTenantIsolationEnabled(event.getContext().getCoreSession())) {
                return;
            }
            List<String> prohibitedGroups = mts.getProhibitedGroups();
            DocumentModel target = ((DocumentEventContext)event.getContext()).getSourceDocument();
            ACP newACP = (ACP)event.getContext().getProperty("newACP");
            for (ACL acl : newACP.getACLs()) {
                int idx = 0;
                for (ACE ace : acl.getACEs()) {
                    String tenantId;
                    if (ace.isGranted() && prohibitedGroups.contains(ace.getUsername()) && (tenantId = MultiTenantHelper.getOwningTenantId(target)) != null) {
                        acl.set(idx, (Object)new ACE(MultiTenantHelper.computeTenantMembersGroup(tenantId), ace.getPermission(), ace.isGranted()));
                    }
                    ++idx;
                }
            }
        }
    }
}

