/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.standalone.LocalPackageImpl;
import org.nuxeo.connect.update.standalone.PackageTestCase;
import org.nuxeo.connect.update.standalone.StandaloneUpdateService;
import org.nuxeo.connect.update.xml.PackageDefinitionImpl;
import org.nuxeo.runtime.api.Framework;

public class TestPackageBuildAndParse
extends PackageTestCase {
    protected void doTestBuildAndParse(boolean cap) throws Exception {
        String name = "test-parse-" + (cap ? "cap" : "nocap");
        InputStream xmlIn = this.getClass().getClassLoader().getResourceAsStream("packages/" + name + "/package.xml");
        XMap xmap = StandaloneUpdateService.createXmap();
        PackageDefinitionImpl packageDef = (PackageDefinitionImpl)xmap.load(xmlIn);
        Assert.assertEquals((Object)"nuxeo-automation", (Object)packageDef.getName());
        Assert.assertEquals((Object)"Nuxeo", (Object)packageDef.getVendor());
        Assert.assertTrue((boolean)packageDef.requireTermsAndConditionsAcceptance());
        Assert.assertTrue((boolean)packageDef.supportsHotReload());
        HashSet<String> expectedTargetPlatforms = new HashSet<String>(Arrays.asList("dm-5.3.2", "dam-5.3.2"));
        if (cap) {
            expectedTargetPlatforms.add("cap-8.3");
            expectedTargetPlatforms.add("server-8.3");
        }
        Assert.assertEquals(expectedTargetPlatforms, new HashSet<String>(Arrays.asList(packageDef.getTargetPlatforms())));
        HashSet<String> deps = new HashSet<String>();
        for (PackageDependency pd : packageDef.getDependencies()) {
            deps.add(pd.toString());
        }
        HashSet<String> expectedDependencies = new HashSet<String>(Arrays.asList("nuxeo-runtime:5.3.1", "nuxeo-core:5.3.1:5.3.2"));
        if (cap) {
            expectedDependencies.add("nuxeo-jsf-ui");
        }
        Assert.assertEquals(expectedDependencies, deps);
        File zip = this.getTestPackageZip(name);
        File tmpDir = new File(Environment.getDefault().getTemp(), "TestPkg" + System.currentTimeMillis());
        tmpDir.mkdirs();
        ZipUtils.unzip((File)zip, (File)tmpDir);
        LocalPackageImpl pkg = new LocalPackageImpl(tmpDir, PackageState.REMOTE, this.service);
        Framework.trackFile((File)tmpDir, (Object)pkg);
        Assert.assertEquals((Object)"You have to be crazy to use this package", (Object)pkg.getTermsAndConditionsContent());
        Assert.assertEquals((Object)"nuxeo-automation", (Object)pkg.getName());
        Assert.assertEquals((Object)"Nuxeo", (Object)pkg.getVendor());
        Assert.assertTrue((boolean)pkg.requireTermsAndConditionsAcceptance());
        Assert.assertTrue((boolean)pkg.supportsHotReload());
        Assert.assertEquals(expectedTargetPlatforms, new HashSet<String>(Arrays.asList(pkg.getTargetPlatforms())));
        deps = new HashSet();
        for (PackageDependency pd : pkg.getDependencies()) {
            deps.add(pd.toString());
        }
        Assert.assertEquals(expectedDependencies, deps);
    }

    @Test
    public void testBuildAndParse() throws Exception {
        this.doTestBuildAndParse(false);
    }

    @Test
    public void testBuildAndParseWithCAP() throws Exception {
        this.doTestBuildAndParse(true);
    }
}

