/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;

public class TestCopyPlatformGuard
extends AbstractCommandTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File distribFile = new File(new File(Environment.getDefault().getHome(), "templates"), "common/config/distribution.properties");
        FileUtils.writeStringToFile((File)distribFile, (String)"org.nuxeo.distribution.version=11.1", (Charset)StandardCharsets.UTF_8);
    }

    @Override
    protected File createPackage() throws IOException, URISyntaxException {
        return this.getTestPackageZip("test-copy-platform-guard");
    }

    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        super.installDone(task, error);
        File dst = this.getTargetFile("111");
        Assert.assertTrue((boolean)dst.exists());
        dst = this.getTargetFile("810");
        Assert.assertFalse((boolean)dst.exists());
    }

    protected File getTargetFile(String suffix) {
        String filename = String.format("test%s.properties", suffix);
        return new File(Environment.getDefault().getConfig(), filename);
    }
}

