/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.launcher.config.AbstractConfigurationTest;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public class ConfigurationGeneratorTest
extends AbstractConfigurationTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        FileUtils.copyDirectory((File)this.getResourceFile("templates/jboss"), (File)new File(this.nuxeoHome, "templates"));
        System.setProperty("jboss.home.dir", this.nuxeoHome.getPath());
    }

    @Test
    public void testEvalDynamicProperties() {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        Assert.assertEquals((String)"Bad loop back URL", (Object)"http://127.0.0.1:8080/nuxeo", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.loopback.url"));
        try {
            this.testAddress("10.213.2.105", "http://10.213.2.105:8080/nuxeo");
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
        }
        log.debug((Object)"Force IPv6");
        System.setProperty("java.net.preferIPv4Stack", "false");
        System.setProperty("java.net.preferIPv6Addresses", "true");
        try {
            this.testAddress("::", "http://[0:0:0:0:0:0:0:1]:8080/nuxeo");
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
        }
        try {
            this.testAddress("2a01:240:fe8e::226:bbff:fe09:55cd", "http://[2a01:240:fe8e:0:226:bbff:fe09:55cd]:8080/nuxeo");
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
        }
    }

    private void testAddress(String bindAddress, String expectedLoopback) throws ConfigurationException {
        this.configGenerator.setProperty("nuxeo.bind.address", bindAddress);
        log.debug((Object)("Test with " + this.configGenerator.getUserConfig().getProperty("nuxeo.bind.address")));
        this.configGenerator.init(true);
        Assert.assertEquals((String)"Bad loop back URL", (Object)expectedLoopback, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.loopback.url"));
    }

    @Test
    public void testSetProperty() throws ConfigurationException {
        String testProperty = "test.prop.key";
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String oldValue = this.configGenerator.setProperty("test.prop.key", "test.prop.value");
        Assert.assertEquals((String)"Wrong old value", null, (Object)oldValue);
        Assert.assertEquals((String)"Property not set", (Object)"test.prop.value", (Object)this.configGenerator.getUserConfig().getProperty("test.prop.key"));
        oldValue = this.configGenerator.setProperty("test.prop.key", null);
        Assert.assertEquals((String)"Wrong old value", (Object)"test.prop.value", (Object)oldValue);
        Assert.assertEquals((String)"Property not unset", null, (Object)this.configGenerator.getUserConfig().getProperty("test.prop.key"));
        oldValue = this.configGenerator.setProperty("test.prop.key", "");
        Assert.assertEquals((String)"Wrong old value", null, (Object)oldValue);
        Assert.assertEquals((String)"Property must not be set", null, (Object)this.configGenerator.getUserConfig().getProperty("test.prop.key"));
        this.configGenerator.setProperty("test.prop.key", "test.prop.value");
        oldValue = this.configGenerator.setProperty("test.prop.key", "");
        Assert.assertEquals((String)"Wrong old value", (Object)"test.prop.value", (Object)oldValue);
        Assert.assertEquals((String)"Property not unset", null, (Object)this.configGenerator.getUserConfig().getProperty("test.prop.key"));
    }

    @Test
    public void testSetSpecialProperties() throws ConfigurationException {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String oldValue = this.configGenerator.setProperty("nuxeo.templates", null);
        Assert.assertEquals((String)"Wrong old value", (Object)"default,common,testinclude", (Object)oldValue);
        Assert.assertEquals((String)"nuxeo.templates should be reset", (Object)"default", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
        this.configGenerator.changeTemplates(oldValue);
        this.configGenerator.setProperty("nuxeo.templates", "");
        Assert.assertEquals((String)"nuxeo.templates should be reset", (Object)"default", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
        this.configGenerator.setProperty("nuxeo.templates", oldValue);
        Assert.assertEquals((String)"nuxeo.templates should be modifiable", (Object)oldValue, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
        oldValue = this.configGenerator.setProperty("nuxeo.force.generation", null);
        Assert.assertEquals((String)"Wrong old value", (Object)"true", (Object)oldValue);
        Assert.assertEquals((String)"Property should not be unset", (Object)oldValue, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.force.generation"));
        this.configGenerator.setProperty("nuxeo.force.generation", "");
        Assert.assertEquals((String)"Property should not be unset", (Object)oldValue, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.force.generation"));
        this.configGenerator.setProperty("nuxeo.force.generation", "false");
        Assert.assertEquals((String)"nuxeo.force.generation should not be modifiable like this", (Object)oldValue, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.force.generation"));
        oldValue = this.configGenerator.setProperty("nuxeo.wizard.done", null);
        Assert.assertEquals((String)"Property should not be unset", (Object)oldValue, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.wizard.done"));
        this.configGenerator.setProperty("nuxeo.wizard.done", "" + !Boolean.parseBoolean(oldValue));
        Assert.assertNotEquals((String)"nuxeo.wizard.done should be modifiable", (Object)oldValue, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.wizard.done"));
        this.configGenerator.setProperty("nuxeo.wizard.done", "" + oldValue);
        Assert.assertEquals((String)"nuxeo.wizard.done should be modifiable", (Object)oldValue, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.wizard.done"));
    }

    @Test
    public void testSetSampledCommentedProperty() throws ConfigurationException {
        String testProperty = "test.sampled.prop";
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String oldValue = this.configGenerator.setProperty("test.sampled.prop", "anotherValue");
        Assert.assertEquals((String)"Wrong old value", null, (Object)oldValue);
        Assert.assertEquals((String)"Property not set", (Object)"anotherValue", (Object)this.configGenerator.getUserConfig().getProperty("test.sampled.prop"));
        oldValue = this.configGenerator.setProperty("test.sampled.prop", null);
        Assert.assertEquals((String)"Wrong old value", (Object)"anotherValue", (Object)oldValue);
        Assert.assertEquals((String)"Property not unset", null, (Object)this.configGenerator.getUserConfig().getProperty("test.sampled.prop"));
        oldValue = this.configGenerator.setProperty("test.sampled.prop", "");
        Assert.assertEquals((String)"Wrong old value", null, (Object)oldValue);
        Assert.assertEquals((String)"Property must not be set", null, (Object)this.configGenerator.getUserConfig().getProperty("test.sampled.prop"));
        this.configGenerator.setProperty("test.sampled.prop", "someValue");
        oldValue = this.configGenerator.setProperty("test.sampled.prop", "");
        Assert.assertEquals((String)"Wrong old value", (Object)"someValue", (Object)oldValue);
        Assert.assertEquals((String)"Property not unset", null, (Object)this.configGenerator.getUserConfig().getProperty("test.sampled.prop"));
    }

    @Test
    public void testSetSampledActiveProperty() throws ConfigurationException {
        String testProperty = "test.sampled.prop2";
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String oldValue = this.configGenerator.setProperty("test.sampled.prop2", "anotherValue");
        Assert.assertEquals((String)"Wrong old value", (Object)"someValue", (Object)oldValue);
        Assert.assertEquals((String)"Property not set", (Object)"anotherValue", (Object)this.configGenerator.getUserConfig().getProperty("test.sampled.prop2"));
        oldValue = this.configGenerator.setProperty("test.sampled.prop2", null);
        Assert.assertEquals((String)"Wrong old value", (Object)"anotherValue", (Object)oldValue);
        Assert.assertEquals((String)"Property not unset", null, (Object)this.configGenerator.getUserConfig().getProperty("test.sampled.prop2"));
        oldValue = this.configGenerator.setProperty("test.sampled.prop2", "");
        Assert.assertEquals((String)"Wrong old value", null, (Object)oldValue);
        Assert.assertEquals((String)"Property must not be set", null, (Object)this.configGenerator.getUserConfig().getProperty("test.sampled.prop2"));
        this.configGenerator.setProperty("test.sampled.prop2", "someValue");
        oldValue = this.configGenerator.setProperty("test.sampled.prop2", "");
        Assert.assertEquals((String)"Wrong old value", (Object)"someValue", (Object)oldValue);
        Assert.assertEquals((String)"Property not unset", null, (Object)this.configGenerator.getUserConfig().getProperty("test.sampled.prop2"));
    }

    @Test
    public void testAddRmTemplate() throws ConfigurationException {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String originalTemplates = this.configGenerator.getUserConfig().getProperty("nuxeo.templates");
        Assert.assertEquals((String)"Error calculating db template", (Object)"default", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.dbtemplate"));
        this.configGenerator.addTemplate("newTemplate");
        Assert.assertEquals((String)"Error calculating db template", (Object)"postgresql", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.dbtemplate"));
        Assert.assertEquals((String)"newTemplate not added", (Object)(originalTemplates + ",newTemplate"), (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
        this.configGenerator.rmTemplate("newTemplate");
        Assert.assertEquals((String)"Error calculating db template", (Object)"default", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.dbtemplate"));
        Assert.assertEquals((String)"newTemplate not removed", (Object)originalTemplates, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
    }

    @Test
    public void testSetWizardDone() throws ConfigurationException {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        HashMap<String, String> changedParameters = new HashMap<String, String>();
        changedParameters.put("nuxeo.wizard.done", "true");
        this.configGenerator.saveFilteredConfiguration(changedParameters);
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        Assert.assertEquals((Object)"true", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.wizard.done"));
    }

    @Test
    public void testFreemarkerTemplate() throws ConfigurationException, IOException {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        this.configGenerator.addTemplate("fmtest");
        this.configGenerator.setProperty("test.freemarker.part1", "tr");
        this.configGenerator.setProperty("test.freemarker.part2", "ue");
        this.configGenerator.setProperty("test.freemarker.key", "${test.freemarker.part1}${test.freemarker.part2}");
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        this.configGenerator.run();
        File outfile = new File(this.nuxeoHome, "testfm");
        Assert.assertTrue((boolean)outfile.exists());
        String fileContents = FileUtils.readFileToString((File)outfile).trim();
        Assert.assertEquals((Object)fileContents, (Object)"Success");
    }

    @Test
    public void testChangeDatabase() throws Exception {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String originalTemplates = this.configGenerator.getUserConfig().getProperty("nuxeo.templates");
        this.configGenerator.changeDBTemplate("postgresql");
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)originalTemplates.replaceFirst("default", "postgresql"), (Object)this.configGenerator.getUserTemplates());
    }

    @Test
    public void testChangeDatabaseFromCustom() throws Exception {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        this.configGenerator.changeTemplates("testinclude2");
        String originalTemplates = this.configGenerator.getUserConfig().getProperty("nuxeo.templates");
        this.configGenerator.changeDBTemplate("postgresql");
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)(originalTemplates + ",postgresql"), (Object)this.configGenerator.getUserTemplates());
        HashMap<String, String> customParameters = new HashMap<String, String>();
        customParameters.put("nuxeo.dbtemplate", "postgresql");
        this.configGenerator.saveFilteredConfiguration(customParameters);
        Assert.assertTrue((boolean)this.configGenerator.init(true));
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)(originalTemplates + ",postgresql"), (Object)this.configGenerator.getUserTemplates());
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)(originalTemplates + ",postgresql"), (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)"postgresql", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.dbtemplate"));
    }

    @Test
    public void testCheckJavaVersionFail() throws Exception {
        this.testCheckJavaVersion(true);
    }

    @Test
    public void testCheckJavaVersionNoFail() throws Exception {
        this.testCheckJavaVersion(false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongJavaVersionFail() {
        ConfigurationGenerator.checkJavaVersion((String)"1.not-a-version", (String)"1.8.0_40", (boolean)false, (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongPreJdk9VersionFail() {
        ConfigurationGenerator.checkJavaVersion((String)"1.not-a-version", (String)"1.8.0_40", (boolean)false, (boolean)false);
    }

    @Test
    public void testWrongJavaVersionNoFail() {
        this.runJVMCheck(false, new Runnable(){

            @Override
            public void run() {
                ConfigurationGenerator.checkJavaVersion((String)"not-a-version", (String)"1.8.0_40", (boolean)true, (boolean)true);
            }
        });
    }

    protected void testCheckJavaVersion(final boolean fail) {
        this.runJVMCheck(fail, new Runnable(){

            @Override
            public void run() {
                ConfigurationGeneratorTest.this.checkJavaVersions(!fail);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runJVMCheck(boolean fail, Runnable runnable) {
        String old = System.getProperty("jvmcheck");
        try {
            System.setProperty("jvmcheck", fail ? "fail" : "nofail");
            runnable.run();
        }
        finally {
            if (old == null) {
                System.clearProperty("jvmcheck");
            } else {
                System.setProperty("jvmcheck", old);
            }
        }
    }

    protected void checkJavaVersions(boolean compliant) {
        this.checkJavaVersion(true, "1.7.0_10", "1.7.0_1");
        this.checkJavaVersion(true, "1.8.0_92", "1.7.0_1");
        this.checkJavaVersion(true, "1.8.0_40", "1.8.0_40");
        this.checkJavaVersion(true, "1.8.0_45", "1.8.0_40");
        this.checkJavaVersion(true, "1.8.0_101", "1.8.0_40");
        this.checkJavaVersion(true, "1.8.0_400", "1.8.0_40");
        this.checkJavaVersion(true, "1.8.0_72-internal", "1.8.0_40");
        this.checkJavaVersion(true, "1.8.0-internal", "1.8.0");
        this.checkJavaVersion(true, "1.9.0_1", "1.8.0_40");
        this.checkJavaVersion(compliant, "1.7.0_1", "1.8.0_40");
        this.checkJavaVersion(compliant, "1.7.0_40", "1.8.0_40");
        this.checkJavaVersion(compliant, "1.7.0_101", "1.8.0_40");
        this.checkJavaVersion(compliant, "1.7.0_400", "1.8.0_40");
        this.checkJavaVersion(compliant, "1.8.0_1", "1.8.0_40");
        this.checkJavaVersion(compliant, "1.8.0_25", "1.8.0_40");
        this.checkJavaVersion(compliant, "1.8.0_39", "1.8.0_40");
    }

    protected void checkJavaVersion(boolean compliant, String version, String requiredVersion) {
        Assert.assertTrue((String)(version + " vs " + requiredVersion), (compliant == ConfigurationGenerator.checkJavaVersion((String)version, (String)requiredVersion, (boolean)true, (boolean)false) ? 1 : 0) != 0);
    }

    @Test
    public void testCheckJavaVersionCompliant() throws Exception {
        final LogCaptureAppender logCaptureAppender = new LogCaptureAppender(Level.WARN);
        Logger.getRootLogger().addAppender((Appender)logCaptureAppender);
        try {
            ConfigurationGenerator.checkJavaVersion((String)"1.7.0_10", (String[])new String[]{"1.7.0_1", "1.8.0_1"});
            Assert.assertTrue((boolean)logCaptureAppender.isEmpty());
            ConfigurationGenerator.checkJavaVersion((String)"1.8.0_92", (String[])new String[]{"1.7.0_1", "1.8.0_1"});
            Assert.assertTrue((boolean)logCaptureAppender.isEmpty());
            ConfigurationGenerator.checkJavaVersion((String)"1.8.0_50", (String[])new String[]{"1.8.0_40"});
            Assert.assertTrue((boolean)logCaptureAppender.isEmpty());
            ConfigurationGenerator.checkJavaVersion((String)"1.8.0_92", (String[])new String[]{"1.7.0_1"});
            Assert.assertEquals((long)1L, (long)logCaptureAppender.size());
            Assert.assertEquals((Object)"Nuxeo requires Java 1.7.0_1+ (detected 1.8.0_92).", (Object)logCaptureAppender.get(0));
            logCaptureAppender.clear();
            ConfigurationGenerator.checkJavaVersion((String)"1.8.0_92", (String[])new String[]{"1.6.0_1", "1.7.0_1"});
            Assert.assertEquals((long)1L, (long)logCaptureAppender.size());
            Assert.assertEquals((Object)"Nuxeo requires Java 1.7.0_1+ (detected 1.8.0_92).", (Object)logCaptureAppender.get(0));
            logCaptureAppender.clear();
            this.runJVMCheck(false, new Runnable(){

                @Override
                public void run() {
                    try {
                        ConfigurationGenerator.checkJavaVersion((String)"1.6.0_1", (String[])new String[]{"1.7.0_1"});
                        Assert.assertEquals((long)1L, (long)logCaptureAppender.size());
                        Assert.assertEquals((Object)"Nuxeo requires Java 1.7.0_1+ (detected 1.6.0_1).", (Object)logCaptureAppender.get(0));
                        logCaptureAppender.clear();
                    }
                    catch (Exception e) {
                        Assert.fail((String)("Exception thrown " + e.getMessage()));
                    }
                }
            });
            try {
                ConfigurationGenerator.checkJavaVersion((String)"1.6.0_1", (String[])new String[]{"1.7.0_1"});
            }
            catch (ConfigurationException ce) {
                Assert.assertEquals((Object)"Nuxeo requires Java {1.7.0_1} (detected 1.6.0_1). See 'jvmcheck' option to bypass version check.", (Object)ce.getMessage());
            }
        }
        finally {
            Logger.getRootLogger().removeAppender((Appender)logCaptureAppender);
        }
    }

    @Test
    public void testReloadConfigurationWhenConfigurationFileWasEditedByAnotherGenerator() throws Exception {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        this.configGenerator.saveConfiguration(Collections.singletonMap("nuxeo.templates", "default,mongodb"));
        Assert.assertEquals((Object)"default,common,testinclude", (Object)this.configGenerator.getUserTemplates());
        Assert.assertEquals((Object)"default,common,testinclude", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
        Assert.assertTrue((boolean)this.configGenerator.init(true));
        Assert.assertEquals((Object)"default,mongodb", (Object)this.configGenerator.getUserTemplates());
        Assert.assertEquals((Object)"default,mongodb", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
    }

    private static class LogCaptureAppender
    extends AppenderSkeleton {
        private final List<String> messages = new ArrayList<String>();
        private final Level level;

        public LogCaptureAppender(Level level) {
            this.level = level;
        }

        protected void append(LoggingEvent event) {
            if ("org.nuxeo.launcher.config.ConfigurationGenerator".equals(event.getLoggerName()) && this.level.equals((Object)event.getLevel())) {
                this.messages.add(event.getRenderedMessage());
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public boolean isEmpty() {
            return this.messages.isEmpty();
        }

        public String get(int i) {
            return this.messages.get(i);
        }

        public int size() {
            return this.messages.size();
        }

        public void clear() {
            this.messages.clear();
        }
    }
}

