/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.migration;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.runtime.migration.Migration;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.migration.MigrationStep;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.runtime.kv"}), @Deploy(value={"org.nuxeo.runtime.migration"}), @Deploy(value={"org.nuxeo.runtime.migration.tests:OSGI-INF/dummy-migration.xml"})})
public class TestMigrationService {
    @Inject
    protected MigrationService migrationService;

    @Test
    public void testGetMigration() {
        this.assertDummyMigration(this.migrationService.getMigration("dummy-migration"));
    }

    @Test
    public void testGetMigrations() {
        List migrations = this.migrationService.getMigrations();
        Assert.assertEquals((long)2L, (long)migrations.size());
        this.assertDummyMigration((Migration)migrations.get(0));
        this.assertDummyMultiMigration((Migration)migrations.get(1));
    }

    @Test
    public void testUnknownMigration() {
        Assert.assertNull((Object)this.migrationService.getMigration("fake"));
    }

    @Test
    public void testProbeAndRunMigration() {
        String dummyMigration = "dummy-migration";
        Assert.assertEquals((Object)"before", (Object)this.migrationService.getMigration(dummyMigration).getStatus().getState());
        this.migrationService.probeAndRun(dummyMigration);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> "after".equals(this.migrationService.getMigration(dummyMigration).getStatus().getState()));
        this.migrationService.probeAndRun(dummyMigration);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> "reallyAfter".equals(this.migrationService.getMigration(dummyMigration).getStatus().getState()));
        try {
            this.migrationService.probeAndRun(dummyMigration);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Migration: dummy-migration must have only one runnable step from state: reallyAfter", (Object)e.getMessage());
        }
        String dummyMultiMigration = "dummy-multi-migration";
        Assert.assertEquals((Object)"before", (Object)this.migrationService.getMigration(dummyMultiMigration).getStatus().getState());
        try {
            this.migrationService.probeAndRun(dummyMultiMigration);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Migration: dummy-multi-migration must have only one runnable step from state: before", (Object)e.getMessage());
        }
    }

    protected void assertDummyMigration(Migration actual) {
        Assert.assertEquals((Object)"dummy-migration", (Object)actual.getId());
        Assert.assertEquals((Object)"Dummy Migration", (Object)actual.getDescription());
        Assert.assertEquals((Object)"migration.dummy", (Object)actual.getDescriptionLabel());
        Assert.assertEquals((Object)"before", (Object)actual.getStatus().getState());
        Assert.assertEquals((Object)"Migrate dummy state from before to after", (Object)((MigrationStep)actual.getSteps().get(0)).getDescription());
    }

    protected void assertDummyMultiMigration(Migration actual) {
        Assert.assertEquals((Object)"dummy-multi-migration", (Object)actual.getId());
        Assert.assertEquals((Object)"Dummy Multi Migration", (Object)actual.getDescription());
        Assert.assertEquals((Object)"multi.migration.dummy", (Object)actual.getDescriptionLabel());
        Assert.assertEquals((Object)"before", (Object)actual.getStatus().getState());
        Assert.assertEquals((Object)"Migrate multi-dummy state from before to after", (Object)((MigrationStep)actual.getSteps().get(0)).getDescription());
    }
}

