/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream.tests;

import java.util.Set;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.runtime.stream.DisableStreamProcessingFeature;
import org.nuxeo.runtime.stream.RuntimeStreamFeature;
import org.nuxeo.runtime.stream.StreamService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={DisableStreamProcessingFeature.class, RuntimeStreamFeature.class})
@Deploy(value={"org.nuxeo.runtime.stream:test-stream-contrib.xml"})
public class TestStreamServiceDisabledProcessing {
    @Inject
    public StreamService service;

    @Test
    public void testStreamProcessor() throws Exception {
        LogManager manager = this.service.getLogManager("default");
        Assert.assertTrue((boolean)manager.exists("input"));
        Assert.assertTrue((boolean)manager.exists("s1"));
        Assert.assertTrue((boolean)manager.exists("output"));
        StreamManager streamManager = this.service.getStreamManager("default");
        streamManager.append("input", Record.of((String)"Hi", null));
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            if (!thread.getName().startsWith("myComputation")) continue;
            Assert.fail((String)("A computation thread has been found: " + threads));
        }
    }
}

